<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);
define("DEBUG", 1);

// Switch off the identifier of session
@ini_set('session.use_trans_sid', 0);

// Check the variables received by the GET's method
if(!preg_match("|^[\d]*$|",$_GET['id_cat'])) exit();
if(!preg_match("|^[\d]*$|",$_GET['id_link'])) exit();
if(!preg_match("|^[\d]*$|",$_GET['logic'])) exit();
if(!preg_match("|^[\d]*$|",$_GET['page'])) exit();
if(!preg_match("|^[\d]*$|",$_GET['id_catalog'])) exit();

// Shield a special characters
if(!get_magic_quotes_gpc())
{
   $_GET['search'] = mysql_escape_string($_GET['search']);
   $_GET['id_cat'] = mysql_escape_string($_GET['id_cat']);
   $_GET['logic'] = mysql_escape_string($_GET['logic']);
   $_GET['url'] = mysql_escape_string($_GET['url']);
   $_GET['id_catalog'] = mysql_escape_string($_GET['id_catalog']);
}

// Require necessary classes
require_once "class/class.exception_mysql.php";
require_once "class/class.exception_object.php";
require_once "class/class.exception_member.php";
require_once 'class/Sigma.php';

// Require necessary libs
require_once "lib/connect.inc";
require_once "lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/index.inc";
   require "templates/language/".$settings['language']."/language.inc";

   if($settings['view_order'] == 1) { $order = "time"; }
   else { $order = "count"; }
   if($settings['order_link'] == 1) { $desc = ""; }
   else { $desc = "DESC"; }

   if(!empty($_GET['id_link']))
   {
      // include template
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/info.html");

      $query = "SELECT * FROM ".DB_LINK." WHERE hide = 'show' AND id_link = ".$_GET['id_link'];
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      $links = $result->fetch_array();

      // Clear the descriptor
      $result->close();

      $query = "SELECT * FROM ".DB_CATALOG." WHERE id_cat = ".$links['id_cat'];
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      $row = $result->fetch_array();

      // Clear the descriptor
      $result->close();

      $description = $links['description_link'];
      $keywords = $links['kwdlink'];
      $title = "$titlepage $version - ".$row['name']."";

      if(empty($title)) { $title = "$titlepage $version"; }
      if(empty($keywords)) { $keywords = ""; }
      if(empty($description)) { $description = $descriptionpage; }

      // Header
      $tpl->setVariable(array('charset'     => $charset,
                              'title'       => $title,
                              'description' => $description,
                              'keywords'    => $keywords,
                              'version'     => $version,
                              'onload'      => ''));

      $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
      $result = $dbh->query($query);
      $total = $result->fetch_assoc();

      // Clear the descriptor
      $result->close();

      $tpl->setVariable(array('name_title' => $name_title,
                              'name'       => $row['name']));

      $links['full_description_link'] = preg_replace("/\\r\\n/s","<br />", $links['full_description_link']);

      if($settings['static'] == 1)
      {
         $link_go_back = "".root()."page_".$links['id_cat']."_1.html";
      }
      else
      {
         $link_go_back = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_cat=".$links['id_cat'];
      }

      $tpl->setVariable(array('link_go_back' => $link_go_back));

      $url_to_site = "".$_SERVER['PHP_SELF']."?id_link=".$links['id_link']."&url=".$links['url']."";

      $tpl->setVariable(array('url'                   => $links['url'],
                              'name_url'              => $links['name'],
                              'full_description_link' => $links['full_description_link'],
                              'url_to_site'           => $url_to_site,
                              'GO_BACK'               => $STR_GO_BACK,
                              'GO_TO_WEBSITE'         => GO_TO_WEBSITE));

      if($total['COUNT(*)']>3)
      {
         $tpl->setVariable(array('show_inc' => ''));
         $tpl->parse('int');
      }

      if($_GET['url'])
      {
         // If there is a URL then count one click
         $update = "UPDATE ".DB_LINK." SET count=COUNT+1 WHERE id_link = ".$_GET['id_link'];

         if($dbh->query($update))
         {
           // Make a redirect
           $tpl->setVariable(array('redirect_url' => $links['url']));
           $tpl->parse('redirect');
         }
      }

      // footer
      $tpl->setVariable(array('LOGO'   => LOGO,
                              'AUTHOR' => AUTHOR));

      // print html page
      $tpl->show();
   }
   else
   {
      // include template
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/index.html");

      if(!empty($_GET['id_cat']))
      {
         // Get the meta tags of catalogue
         $query = "SELECT description,keywords,name FROM ".DB_CATALOG." WHERE id_cat = ".$_GET['id_cat'];
         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

         $row         = $result->fetch_assoc();
         $description = $row['description'];
         $keywords    = $row['keywords'];
         $title       = "$titlepage $version - ".$row['name'];

         // Clear the descriptor
         $result->close();
      }

      if(empty($title)) { $title = "$titlepage $version"; }
      if(empty($keywords)) { $keywords = ""; }
      if(empty($description)) { $description = $descriptionpage; }

      $search = stripslashes(trim(urldecode($_GET['search'])));

      // Elements of the pagination
      if(empty($settings['all_number_link'])) { $all_number_link = 5; }
      else { $all_number_link = $settings['all_number_link']; }

      $page = $_GET['page'];

      if(empty($page)) $page = 1;
      $begin = ($page - 1)*$all_number_link;

      $query = "SELECT * FROM ".DB_CATALOG." ORDER BY name";
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      while($row = $result->fetch_array())
      {
         if($row['id_cat'] == $row['id_parent']) { $arraycat[] = array($row['name'],$row['id_cat']); }
      }

      // Clear the descriptor
      $result->close();

      $total = count($arraycat);

      $number = (int)($total/$settings['stl']);
      if((float)($total/$settings['stl']) - $number != 0) $number++;

      // Form an array
      for($i=0; $i<$number; $i++)
      {
         for($j=0; $j<$settings['stl']; $j++)
         {
            $arr[$i][$j] = $arraycat[$j*$number + $i];
         }
      }

      $print_cat = '';

      for($i = 0; $i < $number; $i++)
      {
         $print_cat .= '<tr>';

         for($j = 0; $j < $settings['stl']; $j++)
         {
            if($arr[$i][$j][0])
            {
               $query = "SELECT * FROM ".DB_CATALOG." WHERE id_parent = ".$arr[$i][$j][1]." ORDER BY name";
               $result = $dbh->query($query);

               if($result->num_rows == 1)
               {
                  if($settings['static'] == "1") { $tlink = "".root()."page_".$arr[$i][$j][1]."_1.html"; }
                  else { $tlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_cat=".$arr[$i][$j][1]; }

                  $query2 = "SELECT COUNT(*) FROM ".DB_LINK." WHERE id_cat = ".$arr[$i][$j][1]." AND hide = 'show'";
                  $result2 = $dbh->query($query2);
                  $total = $result2->fetch_assoc();

                  // Clear the descriptor
                  $result2->close();

                  $print_cat .= "<td><table border=\"0\" class=\"folder\"><tr>
                  <td><img border=\"0\" src=\"images/folder.gif\"></td>
                  <td><p><a href=\"$tlink\">".$arr[$i][$j][0]."</a>&nbsp;(".$total['COUNT(*)'].")</p></td>
                  </tr>";
               }
               else
               {
                  $print_cat .= "<td>
                  <table border=\"0\" class=\"folder\"><tr>
                  <td><img border=\"0\" src=\"images/folder.gif\"></td>
                  <td><p>".$arr[$i][$j][0]."</p></td>
                  </tr>";

                  while($row = $result->fetch_array())
                  {
                     if($row['id_cat'] != $arr[$i][$j][1])
                     {
                        $query2 = "SELECT COUNT(*) FROM ".DB_LINK." WHERE id_cat = ".$row['id_cat']." AND hide = 'show'";
                        $result2 = $dbh->query($query2);
                        $total = $result2->fetch_assoc();

                        // Clear the descriptor
                        $result2->close();

                        if($settings['static'] == "1") { $tlink = "".root()."page_".$row['id_cat']."_1.html"; }
                        else { $tlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_cat=".$row['id_cat']; }

                        $print_cat .= '<tr><td></td>';
                        $print_cat .= "<td><p><a href=\"$tlink\">".$row['name']."</a>&nbsp;(".$total['COUNT(*)'].")</p></td></tr>";
                     }
                  }
               }

               // Clear the descriptor
               $result->close();

               $print_cat .= '</table></td>';
            }
         }

         $print_cat .= '</tr>';
      }

      $searchform = Array();
      $searchform['search'] = urldecode($_GET['search']);

      // Print the list of catalogues and subcatalogues
      $query = "SELECT * FROM ".DB_CATALOG." ORDER BY name";
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      if($_GET['id_catalog'] == 0) { $slct = "selected"; }
      else { $slct = ""; }

      $print_option = '';

      $arraycat = Array();
      $array_id_parent = Array();

      while($list = $result->fetch_array())
      {
         $arraycat[] = array($list['name'], $list['id_cat'],$list['id_parent']);
         $array_id_parent[] = $list['id_parent'];
      }

      // Clear the descriptor
      $result->close();

      for($i=0; $i < count($arraycat); $i++)
      {
         if($array_id_parent[$i] == $arraycat[$i][1])
         {
            $count_sub=0;

            for($m=0; $m < count($arraycat); $m++)
            {
               if($array_id_parent[$i] == $arraycat[$m][2])
               {
                  if($array_id_parent[$i] != $arraycat[$m][1]) $count_sub++;
               }
            }

            if($count_sub != 0)
            {
               if($arraycat[$n][1] == $_GET['id_catalog']) { $slct = "selected"; }
               else { $slct = ""; }

               $searchform['print_option'] .= "<option value=".$arraycat[$i][1]." style=\"color: graytext;\" disabled=\"disabled\" $slct>".$arraycat[$i][0]."</option>\n";

               for($n=0; $n < count($arraycat); $n++)
               {
                  if($array_id_parent[$i] == $arraycat[$n][2])
                  {
                     if($arraycat[$n][1] == $_GET['id_catalog']) { $slct = "selected"; }
                     else { $slct = ""; }
                     if($array_id_parent[$i] != $arraycat[$n][1]) $searchform['print_option'] .= "<option value=".$arraycat[$n][1]." style=\"color: menutext;\" $slct>&nbsp;&nbsp;&nbsp;".$arraycat[$n][0]."</option>\n";
                  }
               }
            }
            else
            {
               if($arraycat[$i][1] == $_GET['id_catalog']) { $slct = "selected"; }
               else { $slct = ""; }
               $searchform['print_option'] .= "<option value=".$arraycat[$i][1]." style=\"color: menutext;\" $slct>".$arraycat[$i][0]."</option>\n";
            }
         }
      }

      if($_GET['logic'] == 0 OR empty($_GET['logic'])) { $searchform['logic0'] = 'checked'; }
      else { $searchform['logic0'] = ''; }

      if($_GET['logic'] == 1) { $searchform['logic1'] = 'checked'; }
      else { $searchform['logic1'] = ''; }

      if(empty($_GET['id_cat']) AND empty($_GET['search']) AND empty($_GET['id_link']))
      {
         // Header
         $tpl->setVariable(array('charset'     => $charset,
                                 'title'       => $title,
                                 'description' => $description,
                                 'keywords'    => $keywords,
                                 'version'     => $version,
                                 'onload'      => ''));

         $tpl->setVariable(array('print_cat' => $print_cat,
                                 'slct'      => $slct,
                                 'CATALOG_SEARCH' => CATALOG_SEARCH,
                                 'KEYWORDS' => KEYWORDS,
                                 'SEARCH'   => SEARCH,
                                 'IT_DOESNT_MATTER'     => IT_DOESNT_MATTER,
                                 'MEETINGS_OF_KEYWORDS' => MEETINGS_OF_KEYWORDS,
                                 'AT_LEAST_ONCE'      => AT_LEAST_ONCE,
                                 'ALL_WORDS_TOGETHER' => ALL_WORDS_TOGETHER,
                                 'FIND'               => FIND));

         $tpl->setVariable(array('search' => $searchform['search'],
                                 'option' => $searchform['print_option'],
                                 'logic0' => $searchform['logic0'],
                                 'logic1' => $searchform['logic1']));


          $tpl->setVariable(array('NEW_LINKS' => NEW_LINKS,
                                  'ADD_URL' => ADD_URL));

         // Print a last added links
         $query = "SELECT * FROM ".DB_LINK."
                   WHERE hide = 'show'
                   ORDER BY time DESC
                   LIMIT ".$settings['all_number_new'];

         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

         if($result->num_rows > 0)
         {
            $no_links = '';

            while($links = $result->fetch_array())
            {
               if($settings['static'] == "1")
               {
                  if($_GET['page']) { $dlink = "".root()."link_".$links['id_link']."_".$_GET['page'].".html"; }
                  else { $dlink = "".root()."link_".$links['id_link'].".html"; }
               }
               else
               {
                  if($_GET['page']) { $dlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_link=".$links['id_link']."&page=".$_GET['page']; }
                  else { $dlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_link=".$links['id_link']; }
               }

               // Print links
               $query2 = "SELECT name FROM ".DB_CATALOG." WHERE id_cat = ".$links['id_cat'];
               $result2 = $dbh->query($query2);

               $catalog = $result2->fetch_array();

               if(!empty($links['htmlcode_banner'])) { $htmlcode_banner = $links['htmlcode_banner']; }
               else { $htmlcode_banner = "<a href=http://".$links['url']." target=_blank><img border=0 width=88 height=31 src=images/notimage.gif></a>"; }

               if(!empty($links['htmlcode_link'])) { $description_link = $links['description_link']; }
               else { $description_link = "<a href=http://".$links['url']." target=_blank>".$links['name']." - ".nl2br($links['description_link'])."</a>"; }

               if($settings['show_pr'] == "yes") { $show_pr = "<iframe src=\"show_pr.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>&nbsp;"; }
               else { $show_pr = ''; }
               if($settings['show_cy'] == "yes") { $show_cy = "<iframe src=\"show_cy.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
               else { $show_cy = ''; }

               $tpl->setVariable(array('READ_MORE'        => READ_MORE,
                                       'ADDED'            => ADDED,
                                       'CHAPTER'          => CHAPTER,
                                       'NUMBER_OF_CLICKS' => NUMBER_OF_CLICKS));

               // print links
               $tpl->setVariable(array('htmlcode_banner'  => $htmlcode_banner,
                                       'description_link' => $description_link,
                                       'dlink'            => $dlink,
                                       'time'             => $links['time'],
                                       'razdel'           => $catalog['name'],
                                       'click'            => $links['count'],
                                       'show_pr'          => $show_pr,
                                       'show_cy'          => $show_cy));

               $tpl->parse('mainpage_links');
            }
         }
         else
         {
            // if there are not any links then print the message
            $no_links = "<p align=center class=msg>$MSG_NOTLINKS</p><br />";
         }

         $tpl->setVariable(array('name_link_addlink' => $name_link_addlink,
                                 'no_links'          => $no_links));

         $tpl->parse('mainpage');
      }

      if(!empty($_GET['id_cat']) AND empty($_GET['search']))
      {
         // Header
         $tpl->setVariable(array('charset'     => $charset,
                                 'title'       => $title,
                                 'description' => $description,
                                 'keywords'    => $keywords,
                                 'version'     => $version,
                                 'onload'      => ''));

         $tpl->setVariable(array('print_cat' => $print_cat,
                                 'slct'      => $slct,
                                 'CATALOG_SEARCH' => CATALOG_SEARCH,
                                 'KEYWORDS' => KEYWORDS,
                                 'SEARCH'   => SEARCH,
                                 'IT_DOESNT_MATTER'     => IT_DOESNT_MATTER,
                                 'MEETINGS_OF_KEYWORDS' => MEETINGS_OF_KEYWORDS,
                                 'AT_LEAST_ONCE'      => AT_LEAST_ONCE,
                                 'ALL_WORDS_TOGETHER' => ALL_WORDS_TOGETHER,
                                 'FIND'               => FIND));

         $tpl->setVariable(array('search' => $searchform['search'],
                                 'option' => $searchform['print_option'],
                                 'logic0' => $searchform['logic0'],
                                 'logic1' => $searchform['logic1']));

         $tpl->setVariable(array('ADD_URL'   => ADD_URL,
                                 'NEW_LINKS' => NEW_LINKS));

         // Get the name of catalogue
         $query = "SELECT name FROM ".DB_CATALOG." WHERE id_cat = ".$_GET['id_cat'];
         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

         $catalog = $result->fetch_array();

         // Clear the descriptor
         $result->close();

         if($settings['static'] == "1") { $on_main_page = 'index.html'; }
         else { $on_main_page = 'index.php'; }

         $tpl->setVariable(array('catalog_name'      => $catalog['name'],
                                 'name_link_addlink' => $name_link_addlink,
                                 'on_main_page'      => $on_main_page));

         // Print links
         $query = "SELECT * FROM ".DB_LINK."
                   WHERE id_cat = ".$_GET['id_cat']." AND hide = 'show'
                   ORDER BY $order $desc
                   LIMIT $begin, $all_number_link";

         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

         if($result->num_rows > 0)
         {
            $no_links = '';

            while($links = $result->fetch_array())
            {
               if($settings['static'] == "1")
               {
                  if($_GET['page']) { $dlink = "".root()."link_".$links['id_link']."_".$_GET['page'].".html"; }
                  else { $dlink = "".root()."link_".$links['id_link'].".html"; }
               }
               else
               {
                  if($_GET['page']) { $dlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_link=".$links['id_link']."&page=".$_GET['page']; }
                  else { $dlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_link=".$links['id_link']; }
               }

               // Get the name of link's catalogue
               $query2 = "SELECT name FROM ".DB_CATALOG." WHERE id_cat = ".$links['id_cat'];
               $result2 = $dbh->query($query2);

               $catalog = $result2->fetch_array();

               if(!empty($links['htmlcode_banner'])) { $htmlcode_banner = $links['htmlcode_banner']; }
               else { $htmlcode_banner = "<a href=http://".$links['url']." target=_blank><img border=0 width=88 height=31 src=images/notimage.gif></a>"; }

               if(!empty($links['htmlcode_link'])) { $description_link = $links['description_link']; }
               else { $description_link = "<a href=http://".$links['url']." target=_blank>".$links['name']." - ".nl2br($links['description_link'])."</a>"; }

               if($settings['show_pr'] == "yes") { $show_pr = "<iframe src=\"show_pr.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>&nbsp;"; }
               else { $show_pr = ''; }
               if($settings['show_cy'] == "yes") { $show_cy = "<iframe src=\"show_cy.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
               else { $show_cy = ''; }

               // print links
               $tpl->setVariable(array('READ_MORE'        => READ_MORE,
                                       'ADDED'            => ADDED,
                                       'CHAPTER'          => CHAPTER,
                                       'NUMBER_OF_CLICKS' => NUMBER_OF_CLICKS));

               $tpl->setVariable(array('htmlcode_banner'  => $htmlcode_banner,
                                       'description_link' => $description_link,
                                       'dlink'            => $dlink,
                                       'time'             => $links['time'],
                                       'razdel'           => $catalog['name'],
                                       'click'            => $links['count'],
                                       'show_pr'          => $show_pr,
                                       'show_cy'          => $show_cy));

               $tpl->parse('id_cat_links');
            }

            // Clear the descriptor
            $result->close();

            // Print the pagination
            $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE id_cat = ".$_GET['id_cat']." AND hide = 'show'";
            $result = $dbh->query($query);

            if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

            $total = $result->fetch_assoc();

            // Clear the descriptor
            $result->close();

            $number = intval(($total['COUNT(*)'] - 1) / $all_number_link) + 1;

            // Define the view of url links
            if($settings['static'] == "1")
            {
               if($page != 1) $pervpage = '<a href='.root().'page_'.$_GET['id_cat'].'_1.html>&lt;&lt; </a>
                                           <a href='.root().'page_'.$_GET['id_cat'].'_'.($page - 1).'.html>&lt; </a>';

               if($page != $number) $nextpage = '<a href='.root().'page_'.$_GET['id_cat'].'_'.($page + 1).'.html> &gt;</a>
                                                 <a href='.root().'page_'.$_GET['id_cat'].'_'.$number.'.html> &gt;&gt;</a>';

               // Form the links of pagination
               if($page - 2 > 0) $page2left = '<a href='.root().'page_'.$_GET['id_cat'].'_'.($page - 2).'.html>...'.($page - 2).'</a> | ';
               if($page - 1 > 0) $page1left = '<a href='.root().'page_'.$_GET['id_cat'].'_'.($page - 1).'.html>'.($page - 1) .'</a> | ';
               if($page + 2 <= $number) $page2right = ' | <a href='.root().'page_'.$_GET['id_cat'].'_'.($page + 2).'.html>'.($page + 2).'...</a>';
               if($page + 1 <= $number) $page1right = ' | <a href='.root().'page_'.$_GET['id_cat'].'_'.($page + 1).'.html>'.($page + 1).'</a>';

               // print a pagination
               $tpl->setVariable(array('NUMBER_OF_LINKS' => NUMBER_OF_LINKS,
                                       'PAGES'           => PAGES));

               $tpl->setVariable(array('total_link' => $total['COUNT(*)'],
                                       'pervpage'   => $pervpage,
                                       'page2left'  => $page2left,
                                       'page1left'  => $page1left,
                                       'page'       => $page,
                                       'page1right' => $page1right,
                                       'page2right' => $page2right,
                                       'nextpage'   => $nextpage));
            }
            else
            {
               if($page != 1) $pervpage = '<a href='.$_SERVER[PHP_SELF].'?id_cat='.$_GET['id_cat'].'&page=1>&lt;&lt; </a>
                                           <a href='.$_SERVER[PHP_SELF].'?id_cat='.$_GET['id_cat'].'&page='.($page - 1).'>&lt; </a> ';

               if($page != $number) $nextpage = '<a href='.$_SERVER[PHP_SELF].'?id_cat='.$_GET['id_cat'].'&page='.($page + 1).'> &gt;</a>
                                                 <a href='.$_SERVER[PHP_SELF].'?id_cat='.$_GET['id_cat'].'&page='.$number.'> &gt;&gt;</a>';

               // Form the links of pagination
               if($page - 2 > 0) $page2left = ' <a href='.$_SERVER[PHP_SELF].'?id_cat='.$_GET['id_cat'].'&page='.($page - 2).'>...'.($page - 2).'</a> | ';
               if($page - 1 > 0) $page1left = ' <a href='.$_SERVER[PHP_SELF].'?id_cat='.$_GET['id_cat'].'&page='.($page - 1).'>'.($page - 1).'</a> | ';
               if($page + 2 <= $number) $page2right = ' | <a href='.$_SERVER[PHP_SELF].'?id_cat='.$_GET['id_cat'].'&page='.($page + 2).'>'.($page + 2).'...</a>';
               if($page + 1 <= $number) $page1right = ' | <a href='.$_SERVER[PHP_SELF].'?id_cat='.$_GET['id_cat'].'&page='.($page + 1).'>'.($page + 1).'</a>';

               // print a pagination
               $tpl->setVariable(array('NUMBER_OF_LINKS' => NUMBER_OF_LINKS,
                                       'PAGES'           => PAGES));

               $tpl->setVariable(array('total_link' => $total['COUNT(*)'],
                                       'pervpage'   => $pervpage,
                                       'page1left'  => $page1left,
                                       'page'       => $page,
                                       'page1right' => $page1right,
                                       'page2right' => $page2right,
                                       'nextpage'   => $nextpage));
            }
         }
         else
         {
            $no_links = "<p align=center class=msg>$MSG_NOTLINKS</p><br />";
         }

         // if there are not any links then print the notice
         $tpl->setVariable(array('no_links' => $no_links));

         $tpl->parse('id_cat');
         $tpl->parse('id_cat_pagination');
      }

      // The result of search
      if(!empty($_GET['search']))
      {
         $tpl->setVariable(array('charset'     => $charset,
                                 'title'       => $title,
                                 'description' => $description,
                                 'keywords'    => $keywords,
                                 'version'     => $version,
                                 'onload'      => ''));

         $tpl->setVariable(array('print_cat' => $print_cat,
                                 'slct'      => $slct,
                                 'CATALOG_SEARCH' => CATALOG_SEARCH,
                                 'KEYWORDS' => KEYWORDS,
                                 'SEARCH'   => SEARCH,
                                 'IT_DOESNT_MATTER'     => IT_DOESNT_MATTER,
                                 'MEETINGS_OF_KEYWORDS' => MEETINGS_OF_KEYWORDS,
                                 'AT_LEAST_ONCE'      => AT_LEAST_ONCE,
                                 'ALL_WORDS_TOGETHER' => ALL_WORDS_TOGETHER,
                                 'FIND'               => FIND));

         $tpl->setVariable(array('search' => $searchform['search'],
                                 'option' => $searchform['print_option'],
                                 'logic0' => $searchform['logic0'],
                                 'logic1' => $searchform['logic1']));

         if(strlen($search)>=3)
         {
            $src_qnt_char = '';

            $temp = strtok($search," ");
            $temp = "$temp*";

            if($_GET['logic'] == 1) { $logstr = "and"; }
            else { $logstr = "or"; }

            if($_GET['id_catalog'] == 0) { $tmp2 = "AND hide = 'show'"; }
            else { $tmp2 = "AND hide = 'show' AND id_cat = ".$_GET['id_catalog']; }

            while ($temp)
            {
               if($is_query) { $tmp1 .= " $logstr MATCH (name,description_link,url,full_description_link,email,htmlcode_link,kwdlink) AGAINST ('$temp' IN BOOLEAN MODE) $tmp2"; }
               else { $tmp1 .= "MATCH (name,description_link,url,full_description_link,email,htmlcode_link,kwdlink) AGAINST ('$temp' IN BOOLEAN MODE) $tmp2"; }

               $is_query = true;
               $temp = strtok(" ");
            }

            // Make a search in the DB
            $query = "SELECT * FROM ".DB_LINK."
                      WHERE $tmp1
                      GROUP BY id_link
                      ORDER BY $order $desc
                      LIMIT $begin, $all_number_link";

            $result = $dbh->query($query);

            if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

            if($result->num_rows>0)
            {
               $search_notfound = '';

               while($links = $result->fetch_array())
               {
                  if($settings['static'] == "1")
                  {
                     if($_GET['page']) { $dlink = "".root()."link_".$links['id_link']."_".$_GET['page'].".html"; }
                     else { $dlink = "".root()."link_".$links['id_link'].".html"; }
                  }
                  else
                  {
                     if($_GET['page']) { $dlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_link=".$links['id_link']."&page=".$_GET['page']; }
                     else { $dlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_link=".$links['id_link']; }
                  }

                  // Print links
                  $query2 = "SELECT name FROM ".DB_CATALOG." WHERE id_cat = ".$links['id_cat'];
                  $result2 = $dbh->query($query2);

                  $catalog = $result2->fetch_array();

                  if(!empty($links['htmlcode_banner'])) { $htmlcode_banner = $links['htmlcode_banner']; }
                  else { $htmlcode_banner = "<a href=http://".$links['url']." target=_blank><img border=0 width=88 height=31 src=images/notimage.gif></a>"; }

                  if(!empty($links['htmlcode_link'])) { $description_link = $links['description_link']; }
                  else { $description_link = "<a href=http://".$links['url']." target=_blank>".$links['name']." - ".nl2br($links['description_link'])."</a>"; }

                  if($settings['show_pr'] == "yes") { $show_pr = "<iframe src=\"show_pr.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>&nbsp;"; }
                  else { $show_pr = ''; }
                  if($settings['show_cy'] == "yes") { $show_cy = "<iframe src=\"show_cy.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
                  else { $show_cy = ''; }

                  $tpl->setVariable(array('READ_MORE'        => READ_MORE,
                                          'ADDED'            => ADDED,
                                          'CHAPTER'          => CHAPTER,
                                          'NUMBER_OF_CLICKS' => NUMBER_OF_CLICKS));

                  $tpl->setVariable(array('htmlcode_banner'  => $htmlcode_banner,
                                          'description_link' => $description_link,
                                          'dlink'            => $dlink,
                                          'time'             => $links['time'],
                                          'razdel'           => $catalog['name'],
                                          'click'            => $links['count'],
                                          'show_pr'          => $show_pr,
                                          'show_cy'          => $show_cy));

                  $tpl->parse('search_links');
               }

               // Clear the descriptor
               $result->close();

               // The pagination of a search result
               $tmp2 = "AND hide = 'show'";

               while ($temp)
               {
                  if($is_query) { $tmp1 .= " $logstr MATCH (name,description_link,url,full_description_link,email,htmlcode_link) AGAINST ('$temp' IN BOOLEAN MODE) $tmp2"; }
                  else { $tmp1 .= "MATCH (name,description_link,url,full_description_link,email,htmlcode_link) AGAINST ('$temp' IN BOOLEAN MODE) $tmp2"; }

                  $is_query = true;
                  $temp = strtok(" ");
               }

               $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE $tmp1 AND hide = 'show'";
               $result = $dbh->query($query);

               if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

               $total = $result->fetch_assoc();

               // Clear the descriptor
               $result->close();

               $number = intval(($total['COUNT(*)'] - 1) / $all_number_link) + 1;

               if($page != 1) $pervpage = '<a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page=1>&lt;&lt; </a>
                                           <a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page - 1).'>&lt; </a> ';

               if($page != $number) $nextpage = '<a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page + 1).'> &gt;</a>
                                                 <a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.$number.'> &gt;&gt;</a>';

               // Form the links of pagination
               if($page - 2 > 0) $page2left = '<a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page - 2).'>...'.($page - 2).'</a> | ';
               if($page - 1 > 0) $page1left = '<a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page - 1).'>'.($page - 1) .'</a> | ';
               if($page + 2 <= $number) $page2right = ' | <a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page + 2).'>'.($page + 2).'...</a>';
               if($page + 1 <= $number) $page1right = ' | <a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page + 1).'>'.($page + 1).'</a>';

               // print a pagination
               $tpl->setVariable(array('NUMBER_OF_LINKS' => NUMBER_OF_LINKS,
                                       'PAGES'           => PAGES));

               $tpl->setVariable(array('total_link' => $total['COUNT(*)'],
                                       'pervpage'   => $pervpage,
                                       'page2left'  => $page2left,
                                       'page1left'  => $page1left,
                                       'page'       => $page,
                                       'page1right' => $page1right,
                                       'page2right' => $page2right,
                                       'nextpage'   => $nextpage));
            }
            else
            {
               $search_notfound = "<p align=center class=msg>$MSG_SEARCH_NOTFOUND</p><br />";
            }

            // if no results of search print the notice
            $tpl->setVariable(array('search_notfound' => $search_notfound));
         }
         else
         {
            $src_qnt_char = "<p align=center class=msg>$MSG_SEARCH_QUANTITY_CHARCTER</p><br /><br />";
            $tpl->setVariable(array('src_qnt_char' => $src_qnt_char));
         }

         $tpl->parse('search');
         $tpl->parse('search_pagination');
      }

      if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
      else $LOGO = LOGO;

      // footer
      $tpl->setVariable(array('LOGO'   => $LOGO,
                              'AUTHOR' => AUTHOR));

      // print html page
      $tpl->show();
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("lib/exception_member_debug.inc");
}

?>