<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "class/class.exception_mysql.php";
require "class/class.exception_object.php";
require "class/class.exception_member.php";
require_once 'class/Sigma.php';

// Require necessary libs
require_once "lib/connect.inc";
require_once "lib/function.inc";

try
{
   // Get the Settings
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/help.inc";
   require "templates/language/".$settings['language']."/language.inc";

   // iclude template
   $tpl = new HTML_Template_Sigma('.');
   $tpl->loadTemplateFile("templates/help.html");

   // Header
   $tpl->setVariable(array('charset'     => $charset,
                           'title'       => $titlepage,
                           'description' => $descriptionpage,
                           'keywords'    => $keywordspage,
                           'version'     => $version,
                           'onload'      => ''));

    // content
    $tpl->setVariable(array('help' => $help));

    if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
    else $LOGO = LOGO;

    // footer
    $tpl->setVariable(array('LOGO'   => $LOGO,
                            'AUTHOR' => AUTHOR));

   // print html page
   $tpl->show();

   // Close the DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("lib/exception_member_debug.inc");
}

?>