<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Check an input data
if(!preg_match("|^[\d]*$|",$_POST['id_link'])) exit();
if(!preg_match("|^[\d]*$|",$_GET['id'])) exit();

// Require necessary classes
require "class/class.exception_mysql.php";
require "class/class.exception_object.php";
require "class/class.exception_member.php";
require_once 'class/Sigma.php';

// Require necessary libs
require_once "lib/connect.inc";
require_once "lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   include "templates/language/".$settings['language']."/edit.inc";
   include "templates/language/".$settings['language']."/language.inc";

   $error = "";

   $action = "";
   $action = $_POST["action"];

   if(!empty($action))
   {
      $_POST["url_link"] = trim($_POST["url_link"]);

      // Shield a special characters
      if(!get_magic_quotes_gpc())
      {
         $_POST['url_link'] = mysql_escape_string($_POST['url_link']);
         $_POST['url'] = mysql_escape_string($_POST['url']);
         $_POST['id_link'] = mysql_escape_string($_POST['id_link']);
         $_POST['cod'] = mysql_escape_string($_POST['cod']);
      }

      // Cut http:// from the url of site
      if(!empty($_POST["url_link"]))
      {
         if((substr($_POST['url_link'], 0, 7)) == "http://") { $_POST['url_link'] = str_replace('http://','',$_POST['url_link']); }
      }

      // If $settings['search'] == yes,
      // then find the link on our site. If there is non any link on our site print error
      if(!empty($_POST["url_link"]))
      {
         if($settings['search'] == "yes")
         {
            if(check_url_link ($_POST['url_link']) == true)
            {
               $action = "";
               $error = $error."<li>$MSG_ERROR_NOT_RECIPROCAL_LINK</li>";
            }
         }
      }

      // Check url address of reciprocal link, if it has url address of catalogue in arg=value then print error
      if(!empty($_POST["url_link"]) and $settings['query_check'] == "yes")
      {
         if(query_check ($_POST['url_link']) == true)
         {
            $action = "";
            $error = $error."<li>$MSG_ERROR_ARG_VALUE</li>";
         }
      }

      // Verify domen of reciprocal link and of catalogue
      if(!empty($_POST["url_link"]))
      {
         if(native_check_link($_POST['url_link'],$_POST['url']) == true)
         {
            $action = "";
            $error = $error."<li>$MSG_ERROR_VERIFY_DOMEN</li>";
         }
      }

      // Check value of url_link, if empty then print error
      if(empty($_POST["url_link"]))
      {
         $action = "";
         $error = $error."<li>$MSG_ERROR_NOT_FILLED_URL_LINK</li>";
      }

      // Check key of link
      $query = "SELECT cod FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      $key = $result->fetch_array();

      // Clear the descriptor
      $result->close();

      if($key['cod'] != $_POST['cod'])
      {
         error($MSG_ERROR_EDITLINK);
      }

      // Form the SQL query on edit if not any errors
      if(empty($error))
      {
         $update = "UPDATE ".DB_LINK." SET url_link = '".$_POST['url_link']."',
                                           hide = 'show',
                                           Number_Check = 0,
                                           time_check = NOW(),
                                           reason = ''
                    WHERE id_link = ".$_POST['id_link'];

         if($dbh->query($update))
         {
            echo $MSG_CHANGE;
            exit();
         }
         else
         {
            throw new ExceptionMySQL($dbh->error,$update,"Error executing SQL query!");
         }
      }
      else
      {
         $tpl = new HTML_Template_Sigma('.');
         $tpl->loadTemplateFile("templates/edit.html");

         // Header
         $tpl->setVariable(array('charset'     => $charset,
                                 'title'       => $title,
                                 'description' => $description,
                                 'keywords'    => $keywords,
                                 'version'     => $version,
                                 'onload'      => ''));

         $tpl->setVariable(array('GO_BACK' => $STR_GO_BACK,
                                 'error'   => $error));

         if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
         else $LOGO = LOGO;

         // footer
         $tpl->setVariable(array('LOGO'   => $LOGO,
                                 'AUTHOR' => AUTHOR));

         $tpl->parse('show_error');

         // print html page
         $tpl->show();

         exit();
      }
   }

   if(empty($action))
   {
      if(empty($_GET['id']))
      {
         error($MSG_ERROR_EDITLINK);
      }

      if(empty($_GET['key']))
      {
         error($MSG_ERROR_EDITLINK);
      }

      if(!get_magic_quotes_gpc())
      {
         $_GET['key'] = mysql_escape_string($_GET['key']);
      }

      // Get a link's data
      $query = "SELECT * FROM ".DB_LINK." WHERE id_link = ".$_GET['id'];
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      $links = $result->fetch_array();

      // Clear the descriptor
      $result->close();

      // Verify the link's key and data's one
      if($links['cod'] == $_GET['key'])
      {
         // include template of page
         $tpl = new HTML_Template_Sigma('.');
         $tpl->loadTemplateFile("templates/edit.html");

         // Header
         $tpl->setVariable(array('charset'     => $charset,
                                 'title'       => $title,
                                 'description' => $description,
                                 'keywords'    => $keywords,
                                 'version'     => $version,
                                 'onload'      => ''));

         $tpl->setVariable(array('ADDRESS_OF_REC_LINK_PAGE' => ADDRESS_OF_REC_LINK_PAGE,
                                 'EDIT' => EDIT));

         $tpl->setVariable(array('php_self' => $_SERVER['PHP_SELF'],
                                 'url_link' => $links['url_link'],
                                 'id'       => $_GET['id'],
                                 'key'      => $_GET['key'],
                                 'url'      => $links['url']));

         // footer
         $tpl->setVariable(array('LOGO'   => LOGO,
                                 'AUTHOR' => AUTHOR));

         $tpl->parse('edit');

         // print html page
         $tpl->show();
      }
      else
      {
         // print error if there is an error
         error($MSG_ERROR_EDITLINK);
      }
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("lib/exception_member_debug.inc");
}

?>