<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

class pager_mysql extends pager
{
    // Name of table
    protected $tablename;

    // WHERE-Condition
    protected $where;

    // Criterion of sorting ORDER
    protected $order;

    // Count of position on page
    public $pnumber;

    // Parameters
    public $parameters;

    // second get parametor
    public $secondpar;

    // Constructer
    public function __construct($tablename, $where = "", $order = "", $pnumber= "", $parameters = "", $secondpar = "")
    {
        $this->tablename  = $tablename;
        $this->where      = $where;
        $this->order      = $order;
        $this->pnumber    = $pnumber;
        $this->parameters = $parameters;
        $this->secondpar  = $secondpar;
    }

    public function get_total()
    {

       // Form the query on getting a total of string in the table
       $query = "SELECT COUNT(*) FROM {$this->tablename}
                                      {$this->where}
                                      {$this->order}";

       $tot = $this->parameters->query($query);

       if(!$tot)
       {
          throw new ExceptionMySQL($this->parameters->error,$query, "Error executing SQL query!");
       }

       $count = $tot->fetch_row();

       return $count[0];
    }

    public function get_pnumber()
    {
       // Position number on page
       return $this->pnumber;
    }

    public function get_parameters()
    {
       // Receive object of connection to the DB via $parameters
       return $this->parameters;
    }

    // Return an array of file's string by number page $index
    public function get_page()
    {
       // Current page
       $page = $_GET['page'];

       if(empty($page)) $page = 1;

       // total of string in file
       $total = $this->get_total();

       // Find out number of page in system
       $number = (int)($total/$this->get_pnumber());
       if((float)($total/$this->get_pnumber()) - $number != 0) $number++;

       // Check on, whether required number of page in nterval from 1 to get_total()
       if($page <= 0 || $page > $number) return 0;

       // Get the position of current page
       $arr = array();

       // the number since which it's necessary to choose string of a file
       $first = ($page - 1)*$this->get_pnumber();

       // Get the position of current page
       $query = "SELECT * FROM {$this->tablename}
                               {$this->where}
                               {$this->order}
                 LIMIT $first, {$this->get_pnumber()}";

       $tbl = $this->parameters->query($query);

       if(!$tbl)
       {
          throw new ExceptionMySQL($this->parameters->error,$query,"Error executing SQL query!");
       }

       // Remember the array if there is one element at least
       if($tbl->num_rows)
       {
           while($arr[] = $tbl->fetch_array());
       }

       // Remove a null element of array $arr
       unset($arr[count($arr) - 1]);

       return $arr;
    }
}

?>