<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "class/class.exception_mysql.php";
require "class/class.exception_object.php";
require "class/class.exception_member.php";

// Require necessary libs
require_once "lib/connect.inc";
require_once "lib/function.inc";

try
{
   // Shield a special characters
   $_GET["url"] = strtolower(trim(mysql_escape_string($_GET["url"])));

   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface module
   require "templates/language/".$settings['language']."/language.inc";

   if($_GET["url"])
   {
      // Check whether catalogue has this url
      $url = urldecode($_GET["url"]);

      if((substr($url, 0, 4)) == "www.") { $url = str_replace('www.','',$url); }
      if(substr($url, 0, 7) == "http://") { $url = str_replace('http://','',$url); }
      if(strpos($url,'/')>0) list($url) = explode('/',$url);

      $src_url = str_replace('.','\\.',$url);

      $query = "SELECT * FROM ".DB_LINK." WHERE url RLIKE '^(www\\.)?$src_url$' AND hide = 'show' OR
                                                url RLIKE '^(www\\.)?$src_url$' AND hide = 'black'";

      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      if($result->num_rows > 0)
      {
         echo $MSG_ERROR_EXIST_SITE;
      }

      // Clear the descriptor
      $result->close();

      $query = "SELECT * FROM ".DB_LINK." WHERE url RLIKE '^(www\\.)?$src_url$' AND hide = 'new' OR
                                                url RLIKE '^(www\\.)?$src_url$' AND hide = 'hide'";

      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      if($result->num_rows>0)
      {
         echo $MSG_ERROR_AWAIT_CHECK;
      }

      // Clear the descriptor
      $result->close();

      // Check url on valid
      if(check_url($url) == true)
      {
         echo $MSG_ERROR_WRONG_URL;
      }

      if(native_check_url($url, $_SERVER["SERVER_NAME"]) == true)
      {
         echo $MSG_ERROR_VERIFY_DOMEN;
      }
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("lib/exception_member_debug.inc");
}

?>