<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Set no limit on exucute of script if it's possible
@set_time_limit(0);

// Require necessary classes
require "class/class.exception_mysql.php";
require "class/class.exception_object.php";
require "class/class.exception_member.php";

// Require necessary libs
require_once "lib/connect.inc";
require_once "lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface module
   require "templates/language/".$settings['language']."/language.inc";

   // Check all hidden and new links
   $query = "SELECT * FROM ".DB_LINK." WHERE hide = 'hide'";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   while($links = $result->fetch_array())
   {
      $url_link = $links['url_link'];
      $date_check = strtotime($links['time_check']);
      $interval_check = ceil((time()-$date_check)/3600/24);

      if($links['check_link'] == "yes" AND $interval_check>$settings['day'] AND $interval_check != 1)
      {
         if(check_url_link ($url_link) == true)
         {
            if($settings['black'] == "yes")
            {
               $query2 = "UPDATE ".DB_LINK." SET hide = 'black',
                                                 time = NOW(),
                                                 reason = '$REASON_ABSENSE_RECIPROCAL'
                          WHERE id_link = ".$links['id_link'];
            }
            else
            {
               $query2 = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
            }

            if($dbh->query($query2))
            {
               // Notify the user about his link was removed
               sendmail_del_link($links, $STR_SUBJECT_DEL, $_SERVER['SERVER_NAME']);
            }
         }
         else
         {
            // check on, there is a prohibition on index of reciprocal link by meta tag <meta name=robot>
            if(check_meta($url_link) == true)
            {
               if($settings['black'] == "yes")
               {
                  $query2 = "UPDATE ".DB_LINK." SET hide = 'black',
                                                    time = NOW(),
                                                    reason = '$REASON_CLOSED_FOR_INDEX_META'
                             WHERE id_link = ".$links['id_link'];
               }
               else
               {
                  $query2 = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
               }

               if($dbh->query($query2))
               {
                  // Notify the user about his link was removed
                  sendmail_del_link($links, $STR_SUBJECT_DEL, $_SERVER['SERVER_NAME']);
               }
            }
            else
            {
               // Check on, whether a directory is closed for index in robots.txt file
               if(check_robots($url_link) == true)
               {
                  if($settings['black'] == "yes")
                  {
                     $query2 = "UPDATE ".DB_LINK." SET hide = 'black',
                                                       time = NOW(),
                                                       reason = '$REASON_CLOSED_FOR_INDEX_ROBOT'
                                WHERE id_link = ".$links['id_link'];
                  }
                  else
                  {
                     $query2 = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
                  }

                  if($dbh->query($query2))
                  {
                     // Notify the user about his link was removed
                     sendmail_del_link($links, $STR_SUBJECT_DEL, $_SERVER['SERVER_NAME']);
                  }
               }
               else
               {
                  $query2 = "UPDATE ".DB_LINK." SET hide = 'show',
                                                    time_check = NOW(),
                                                    reason = '',
                                                    Number_Check = '0'
                             WHERE id_link = ".$links['id_link'];

                  if($dbh->query($query2))
                  {
                     // Notify the user about his link was restored
                     sendMailAdd($links, $STR_SUBJECT_DEL, $_SERVER['SERVER_NAME']);
                  }
               }
            }
         }
      }
   }

   // Clear the descriptor
   $result->close();

   // Check all new link
   $query = "SELECT * FROM ".DB_LINK." WHERE hide = 'new'";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   while($links = $result->fetch_array())
   {
      $date_check = strtotime($links['time_check']);
      $interval_check = ceil((time()-$date_check)/3600/24);

      $url_link = $links[url_link];

      if($links['check_link'] == "yes" AND $interval_check > $settings['day'] AND $interval_check != 1)
      {
         if(check_url_link ($url_link) == true)
         {
            $query2 = "UPDATE ".DB_LINK." SET hide = 'show',
                                              time_check = NOW()
                       WHERE id_link = ".$links['id_link'];

            if($dbh->query($query2))
            {
              // Notify the user about his link was added to catalogue
              sendMailAdd($links, $STR_SUBJECT_ADD, $_SERVER['SERVER_NAME']);
            }
         }
         else
         {
            if($settings['black'] == "yes")
            {
               $query2 = "UPDATE ".DB_LINK." SET hide = 'black',
                                                 time = NOW(),
                                                 reason = '$REASON_ABSENSE_RECIPROCAL'
                          WHERE id_link = ".$links['id_link'];

               $dbh->query($query2);
            }
            else
            {
               $query2 = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
               $dbh->query($query2);
            }
         }
      }
   }

   // Clear the descriptor
   $result->close();

   // Check all other links
   $query = "SELECT * FROM ".DB_LINK." WHERE hide = 'show'";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   while($links = $result->fetch_array())
   {
      $url_link = $links['url_link'];
      $date_check = strtotime($links['time_check']);
      $interval_check = ceil((time()-$date_check)/3600/24);

      if($links['check_link'] == "yes" AND $interval_check>$settings['day'] AND $interval_check != 1)
      {
         if(check_url_link ($url_link) == true)
         {
            if($links['Number_Check'] == $settings['Number_Check'])
            {
               // hide link
               $query2 = "UPDATE ".DB_LINK." SET hide = 'hide',
                                                 time_check = NOW(),
                                                 reason = '$REASON_ABSENSE_RECIPROCAL'
                          WHERE id_link = ".$links['id_link'];

               if($dbh->query($query2))
               {
                  // Notify the user about his link was hidden
                  $url_link_edit = "".$HTTP_HOST.root()."edit.php?id=".$links['id_link']."&key=".$links['cod']."";

                  sendmail_hide_link ($links, $url_link_edit, $STR_SUBJECT_HIDE, $_SERVER['SERVER_NAME']);
               }
            }
            else
            {
               $query2 = "UPDATE ".DB_LINK." SET time_check = NOW(), Number_Check=Number_Check+1 WHERE id_link = ".$links['id_link'];
               $dbh->query($query2);
            }
         }
         else
         {
            // Check if there is a prohibition on index for reciprocal link
            if(check_meta($url_link) == true)
            {
               if($links['Number_Check'] == $settings['Number_Check'])
               {
                  // Hide link
                  $query2 = "UPDATE ".DB_LINK." SET hide = 'hide',
                                                    time_check = NOW(),
                                                    reason = '$REASON_CLOSED_FOR_INDEX_ROBOT'
                             WHERE id_link = ".$links['id_link'];

                  if($dbh->query($query2))
                  {
                     // Notify the user about his link was hidded
                     $reason = $MSG_CLOSED_FOR_INDEX_META;

                     sendmail_hide_link2($links, $reason, $STR_SUBJECT_HIDE, $_SERVER['SERVER_NAME']);
                  }
               }
               else
               {
                  $query2 = "UPDATE ".DB_LINK." SET time_check = NOW(), Number_Check=Number_Check+1 WHERE id_link = ".$links['id_link'];
                  $dbh->query($query2);
               }
            }
            else
            {
               // Check robots.txt, if it has a prohibition on index then hide a link
               if(check_robots($url_link) == true)
               {
                  if($links['Number_Check'] == $settings['Number_Check'])
                  {
                     // Hide link
                     $query2 = "UPDATE ".DB_LINK." SET hide = 'hide',
                                                       time_check = NOW(),
                                                       reason = '$REASON_CLOSED_FOR_INDEX_ROBOT'
                                WHERE id_link = ".$links['id_link'];

                     if($dbh->query($query2))
                     {
                        // Notify the user about his link was hidded
                        $reason = $MSG_CLOSED_FOR_INDEX_ROBOT;

                        sendmail_hide_link2($links, $reason, $STR_SUBJECT_HIDE, $_SERVER['SERVER_NAME']);
                     }
                  }
                  else
                  {
                     $query2 = "UPDATE ".DB_LINK." SET time_check = NOW(), Number_Check=Number_Check+1 WHERE id_link = ".$links['id_link'];
                     $dbh->query($query2);
                  }
               }
               else
               {
                  $query2 = "UPDATE ".DB_LINK." SET time_check = NOW(), reason = '', Number_Check = '0' WHERE id_link = ".$links['id_link'];
                  $dbh->query($query2);
               }
            }
         }
      }
   }

   // Clear the descriptor
   $result->close();

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("lib/exception_member_debug.inc");
}

?>