<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "../class/class.pager.php";
require "../class/class.pager_mysql.php";
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/index.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   // Authenticate
   require "../lib/authenticate.inc";

   if(!preg_match("|^[\d]*$|",$_GET['id'])) exit();

   $action = "";
   $action = $_POST["action"];

   // Return values of variable action
   if(empty($action))
   {
      if(!empty($_GET['id']))
      {
         // include temlate
         $tpl = new HTML_Template_Sigma('.');
         $tpl->loadTemplateFile("templates/check_form_link.html");

         // header
         $tpl->setVariable(array('version'   => $version,
                                 'title'     => $title,
                                 'titlepage' => $titlepage,
                                 'charset'   => $charset,
                                 'VERSION'   => VERSION));

         // menu
         $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                                 'ADDLINKTITLE'  => ADDLINKTITLE,
                                 'CATTITLE'      => CATTITLE,
                                 'CHECKTITLE'    => CHECKTITLE,
                                 'EDITTITLE'     => EDITTITLE,
                                 'SETTINGSTITLE' => SETTINGSTITLE,
                                 'BLACKTITLE'    => BLACKTITLE,
                                 'BACKUPTITLE'   => BACKUPTITLE,
                                 'DESIGNTITLE'   => DESIGNTITLE,
                                 'MENUINDEX'     => MENUINDEX,
                                 'MENUADDURL'    => MENUADDURL,
                                 'MENUCAT'       => MENUCAT,
                                 'MENUCHECK'     => MENUCHECK,
                                 'MENUEDIT'      => MENUEDIT,
                                 'MENUSETTING'   => MENUSETTING,
                                 'MENUBLACK'     => MENUBLACK,
                                 'MENUCHANGE'    => MENUCHANGE,
                                 'MENUBACKUP'    => MENUBACKUP,
                                 'MENUDESIGN'    => MENUDESIGN));

         $tpl->setVariable(array('choosenav1' => $choosenav1,
                                 'choosenav2' => $choosenav2,
                                 'choosenav3' => $choosenav3,
                                 'choosenav4' => $choosenav4,
                                 'choosenav5' => $choosenav5,
                                 'choosenav6' => $choosenav6,
                                 'choosenav7' => $choosenav7,
                                 'choosenav8' => $choosenav8,
                                 'choosenav9' => $choosenav9,
                                 'choosenav10' => $choosenav10));

         $query = "SELECT * FROM ".DB_LINK." WHERE id_link = ".$_GET['id'];
         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

         $links = $result->fetch_array();

         // Clear the descriptor
         $result->close();

         // Print the form of link
         $query = "SELECT name FROM ".DB_CATALOG." WHERE id_cat = ".$links['id_cat'];
         $result = $dbh->query($query);
         $chapter = $result->fetch_array();

         // Clear the descriptor
         $result->close();

         if(!empty($links['htmlcode_banner'])) { $htmlcode_banner = $links['htmlcode_banner']; }
         else { $htmlcode_banner = "<a href=\"http://".$links['url']."\"><img border=\"0\" width=\"88\" height=\"31\" src=\"../images/notimage.gif\"></a>"; }

         $links['description_link'] = nl2br($links['description_link']);

         if($settings['show_pr'] == "yes") { $show_pr = "<iframe src=\"show_pr.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"100\" height=\"50\"></iframe>"; }
         else { $show_pr = ''; }

         if($settings['show_cy'] == "yes") { $show_cy = "<iframe src=\"show_cy.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
         else { $show_cy = ''; }

         $button_add = "<td><form action=\"".$_SERVER['PHP_SELF']."\" method=post>
         <input type=submit value=\"$STR_BUTTON_ADD\" class=\"inputsubmit\">
         <input type=hidden name=\"id_link\" value=\"".$links['id_link']."\">
         <input type=hidden name=\"event\" value=\"add\">
         <input type=hidden name=\"action\" value=\"post\">
         </form></td>";

         $button_delete = "<td><form action=\"".$_SERVER['PHP_SELF']."\" method=post>
         <input type=submit value=\"$STR_BUTTON_DELETE\" class=\"inputsubmit\">
         <input type=hidden name=\"id_link\" value=\"".$links['id_link']."\">
         <input type=hidden name=\"event\" value=\"delete\">
         <input type=hidden name=\"action\" value=\"post\">
         </form></td>";

         $button_black = "<td><form action=\"".$_SERVER['PHP_SELF']."\" method=post>
         <input type=submit value=\"$STR_BUTTON_TO_BLACKLIST\" class=\"inputsubmit\">
         <input type=hidden name=\"id_link\" value=\"".$links['id_link']."\">
         <input type=hidden name=\"event\" value=\"black\">
         <input type=hidden name=\"action\" value=\"post\">
         </form></td>";

         // print form
         $tpl->setVariable(array('BACK'            => BACK,
                                 'NAME_OF_WEBSITE' => NAME_OF_WEBSITE,
                                 'DESCRIPTION_OF_WEBSITE' => DESCRIPTION_OF_WEBSITE,
                                 'RECIP_URL_LINK'  => RECIP_URL_LINK,
                                 'CHAPTER'         => CHAPTER,
                                 'ADDED'           => ADDED));

         $tpl->setVariable(array('form_htmlcode_banner'  => $htmlcode_banner,
                                 'form_url'              => $links['url'],
                                 'form_name'             => $links['name'],
                                 'form_description_link' => $links['description_link'],
                                 'form_url_link'         => $links['url_link'],
                                 'form_razdel'           => $chapter['name'],
                                 'form_time'             => $links['time'],
                                 'form_show_pr'          => $show_pr,
                                 'form_show_cy'          => $show_cy,
                                 'form_button_add'       => $button_add,
                                 'form_button_delete'    => $button_delete,
                                 'form_button_black'     => $button_black));

         // Count a quantity of the links
         $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
         $result = $dbh->query($query);
         $total = $result->fetch_assoc();

         // Clear the descriptor
         $result->close();

         if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
         else $LOGO = LOGO;

         // footer
         $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                                 'help'        => $help,
                                 'AUTHOR'      => AUTHOR,
                                 'LOGO'        => $LOGO,
                                 'WEBSITE'     => WEBSITE,
                                 'HELPPAGE'    => HELPPAGE,
                                 'FAQPAGE'     => FAQPAGE,
                                 'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

         // print html page
         $tpl->show();
      }
      else
      {
         // include temlate
         $tpl = new HTML_Template_Sigma('.');
         $tpl->loadTemplateFile("templates/index.html");

         // header
         $tpl->setVariable(array('version'   => $version,
                                 'title'     => $title,
                                 'titlepage' => $titlepage,
                                 'charset'   => $charset,
                                 'VERSION'   => VERSION));

         // menu
         $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                                 'ADDLINKTITLE'  => ADDLINKTITLE,
                                 'CATTITLE'      => CATTITLE,
                                 'CHECKTITLE'    => CHECKTITLE,
                                 'EDITTITLE'     => EDITTITLE,
                                 'SETTINGSTITLE' => SETTINGSTITLE,
                                 'BLACKTITLE'    => BLACKTITLE,
                                 'BACKUPTITLE'   => BACKUPTITLE,
                                 'DESIGNTITLE'   => DESIGNTITLE,
                                 'MENUINDEX'     => MENUINDEX,
                                 'MENUADDURL'    => MENUADDURL,
                                 'MENUCAT'       => MENUCAT,
                                 'MENUCHECK'     => MENUCHECK,
                                 'MENUEDIT'      => MENUEDIT,
                                 'MENUSETTING'   => MENUSETTING,
                                 'MENUBLACK'     => MENUBLACK,
                                 'MENUCHANGE'    => MENUCHANGE,
                                 'MENUBACKUP'    => MENUBACKUP,
                                 'MENUDESIGN'    => MENUDESIGN));

         $tpl->setVariable(array('choosenav1' => $choosenav1,
                                 'choosenav2' => $choosenav2,
                                 'choosenav3' => $choosenav3,
                                 'choosenav4' => $choosenav4,
                                 'choosenav5' => $choosenav5,
                                 'choosenav6' => $choosenav6,
                                 'choosenav7' => $choosenav7,
                                 'choosenav8' => $choosenav8,
                                 'choosenav9' => $choosenav9,
                                 'choosenav10' => $choosenav10));

         // Elements of the pagination
         if(empty($settings['all_number_link'])) { $all_number_link = 5; }
         else { $all_number_link = $settings['all_number_link']; }

         $show_link = new pager_mysql("".DB_LINK."",
                                      "WHERE hide = 'new'",
                                      "ORDER BY time DESC");

         $show_link->pnumber = $all_number_link;
         $show_link->parameters = $dbh;

         $arr = $show_link->get_page();

         if(is_array($arr))
         {
            $notnewlinks = '';

            for($i=0; $i<count($arr); $i++)
            {
               // Print the link
               $query = "SELECT name FROM ".DB_CATALOG." WHERE id_cat = ".$arr[$i]['id_cat'];
               $result = $dbh->query($query);

               if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

               $chapter = $result->fetch_array();

               // Clear the descriptor
               $result->close();

               if(!empty($new_htmlcode_link)) { $new_htmlcode_link = "<p>{$arr[$i]['htmlcode_link']}</p>"; }
               else { $new_htmlcode_link = "<p><a href=\"http://{$arr[$i]['url']}\" target=_blank>{$arr[$i]['name']}</a> - ".nl2br($arr[$i]['description_link'])."</p>"; }

               if(!empty($new_htmlcode_banner)) { $new_htmlcode_banner = $arr[$i]['htmlcode_banner']; }
               else { $new_htmlcode_banner = "<a href=\"http://{$arr[$i]['url']}\" target=_blank><img border=\"0\" width=\"88\" height=\"31\" src=\"../images/notimage.gif\"></a>"; }

               if($settings['show_pr'] == "yes") { $new_show_pr = "<iframe src=\"show_pr.php?url={$arr[$i]['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"100\" height=\"50\"></iframe>"; }
               else { $new_show_pr = ''; }

               if($settings['show_cy'] == "yes") { $new_show_cy = "<iframe src=\"show_cy.php?url={$arr[$i]['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
               else { $new_show_cy = ''; }

               $new_button1 = "<form action=\"index.php?id={$arr[$i]['id_link']}\" method=\"post\">
               <input type=submit class=\"inputsubmit\" value=\"$STR_BUTTON_HANDCHECK\">
               </form>";

               $new_button2 = "<form action=\"index.php\" method=\"post\">
               <input type=submit class=\"inputsubmit\" value=\"$STR_BUTTON_AUTOCHECK\" class=\"button\">
               <input type=hidden name=\"id_link\" value=\"{$arr[$i]['id_link']}\">
               <input type=hidden name=\"url_link\" value={$arr[$i]['url']}>
               <input type=hidden name=\"event\" value=\"auto_check\">
               <input type=hidden name=\"action\" value=\"post\"></form>";

               // print links
               $tpl->setVariable(array('ADDED'  => ADDED,
                                       'CHAPTER'=> CHAPTER,
                                       'EMAIL'  => EMAIL));

               $tpl->setVariable(array('new_htmlcode_banner' => $new_htmlcode_banner,
                                       'new_htmlcode_link'   => $new_htmlcode_link,
                                       'new_time'            => $arr[$i]['time'],
                                       'new_razdel'          => $chapter['name'],
                                       'new_email'           => $arr[$i]['email'],
                                       'new_show_pr'         => $new_show_pr,
                                       'new_show_cy'         => $new_show_cy,
                                       'new_button1'         => $new_button1,
                                       'new_button2'         => $new_button2));

               $tpl->parse('row_links');
            }

            // pagination
            $tpl->setVariable(array('pagination' => $show_link->print_page(),
                                    'PAGES' => PAGES));

            $tpl->parse('print_pagination');
         }
         else
         {
            $notnewlinks = "<p align=\"center\" class=\"msg\">$MSG_NOTNEWLINKS</p><br />";
         }

         $tpl->setVariable(array('notnewlinks' => $notnewlinks));

         // Count a quantity of the links
         $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
         $result = $dbh->query($query);
         $total = $result->fetch_assoc();

         // Clear the descriptor
         $result->close();

         if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
         else $LOGO = LOGO;

         // footer
         $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                                 'help'        => $help,
                                 'AUTHOR'      => AUTHOR,
                                 'LOGO'        => $LOGO,
                                 'WEBSITE'     => WEBSITE,
                                 'HELPPAGE'    => HELPPAGE,
                                 'FAQPAGE'     => FAQPAGE,
                                 'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

         // print html page
         $tpl->show();
      }
   }

   if(!empty($action))
   {
      switch ($_POST['event'])
      {
         case add:

           $query = "UPDATE ".DB_LINK." SET hide = 'show' WHERE id_link = ".$_POST['id_link'];

           if($dbh->query($query))
           {
              $query2 = "SELECT * FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];
              $result = $dbh->query($query2);

              if(!$result) { throw new ExceptionMySQL($dbh->error,$query2,"Error executing SQL query!"); }

              $links = $result->fetch_array();

              // Clear the descriptor
              $result->close();

              sendMailAdd($links,$STR_SUBJECT_ADD, $_SERVER['SERVER_NAME']);

              // Return to the main page if a query was executed successfully
              back($MSG_ADD_LINK,'index.php',2);
           }
           else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

         break;

         // Remove link
         case delete:

           $query = "SELECT * FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];
           $result = $dbh->query($query);

           if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

           $links = $result->fetch_array();

           // Clear the descriptor
           $result->close();

           $delete = "DELETE FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];

           if($dbh->query($delete))
           {
             // Send email to the user about the link has not passed moderation
             sendMailNoAdd($links,$STR_SUBJECT_NOADD, $_SERVER['SERVER_NAME']);

             // Return to the main page if a query was executed successfully
             back($MSG_REMOVE_LINK,'index.php',2);
           }
           else { throw new ExceptionMySQL($dbh->error,$delete,"Error executing SQL query!"); }

         break;

         // Add link to black list
         case black:

           $query = "SELECT * FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];
           $result = $dbh->query($query);

           if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

           $links = $result->fetch_array();

           // Clear the descriptor
           $result->close();

           $update = "UPDATE ".DB_LINK." SET hide = 'black', time = NOW(), reason = '$REASON_ADMIN' WHERE id_link = ".$_POST['id_link'];

           if($dbh->query($update))
           {
             // Send email to the user about the link has not passed a moderation
             sendMailNoAdd($links,$STR_SUBJECT_NOADD, $_SERVER['SERVER_NAME']);

             // Return to the main page if a query was executed successfully
             back($MSG_TO_BLACKLIST_LINK,'index.php',2);
           }
           else { throw new ExceptionMySQL($dbh->error,$update,"Error executing SQL query!"); }

         break;

         // Automatic check the link
         case auto_check:

            if(!empty($settings['my_url']))
            {
               $url_link = $_POST['url_link'];

               // Check is exist answer link on page with address $_POST['url_link']
               if(check_url_link ($url_link) == false)
               {
                  // Add the link if it is
                  $query = "UPDATE ".DB_LINK." SET hide = 'show', time_check = NOW() WHERE id_link = ".$_POST['id_link'];

                  if($dbh->query($query))
                  {
                     // Send email to the user about the link was added
                     $query = "SELECT * FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];
                     $result = $dbh->query($query);

                     if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

                     $links = $result->fetch_array();

                     // Clear the descriptor
                     $result->close();

                     sendMailAdd($links,$STR_SUBJECT_ADD, $_SERVER['SERVER_NAME']);

                     // Return to the main page if a query was executed successfully
                     back('','index.php',0);

                  } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
               }
               else
               {
                  // Remove the link or add to black list if it is not
                  if($settings['black'] == "yes")
                  {
                     $query = "UPDATE ".DB_LINK." SET hide = 'black', time = NOW(), reason = '$REASON_ABSENSE_RECIPROCAL' WHERE id_link = ".$_POST['id_link'];
                  }
                  else
                  {
                     $query = "DELETE FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];
                  }

                  if($dbh->query($query))
                  {
                     // Return to the main page if a query was executed successfully
                     back('','index.php',0);

                  } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
               }
            }

         break;

         default:

           // Return to the main page if a query was executed successfully
           back('','index.php',0);

         break;
      }
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>