<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/language.inc";

   // Authenticate
   require "../lib/authenticate.inc";

   // Check is exist a file
   if(empty($_FILES['dump']['tmp_name'])) { error($MSG_ERROR_IMPORT_PATH); }

   // Open a file
   if(!($fp = @fopen($_FILES['dump']['tmp_name'],"rb")))
   {
      error($MSG_ERROR_IMPORT_FILE);
   }

   // Read the contents of a file to buffer
   $buffer = fread($fp,filesize($_FILES['dump']['tmp_name']));

   // Close a file
   fclose($fp);

   // Split the file on string,
   // and put each string of a file in a separate element of an array $strtmp
   @implode($buffer, "\r\n");

   preg_match_all("/insert into[^;]+\(([^;]*)\);/siU", $buffer, $out, PREG_SET_ORDER);
   preg_match("/-- version (\d+)\.(\d+)\.(\d+)/siU", $buffer, $vrs);

   $dump_ver = $vrs[1].$vrs[2].$vrs[3];
   $dump_ver = (int)$dump_ver;

   // Compare the dump's version with the current version
   if($dump_ver < 100) { error($MSG_ERROR_IMPORT_VERSION); }

   for($i=0; $i<count($out); $i++)
   {
      // Import the categories of the catalogues
      preg_match("/^'(\d+)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'(\d+)'$/siU", $out[$i][1], $insert_cat);

      $insert_cat[1] = trim($insert_cat[1]);
      $insert_cat[2] = trim($insert_cat[2]);
      $insert_cat[3] = trim($insert_cat[3]);
      $insert_cat[4] = trim($insert_cat[4]);
      $insert_cat[5] = trim($insert_cat[5]);

      // Form SQL-query to add data
      if(!empty($insert_cat[1]) and !empty($insert_cat[2]) and !empty($insert_cat[5]))
      {
         $insert[] = "INSERT INTO ".DB_CATALOG." VALUES (".$insert_cat[1].", '".$insert_cat[2]."', '".$insert_cat[3]."', '".$insert_cat[4]."', ".$insert_cat[5].")";
      }

      // Import links
      preg_match("/^'(\d+)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'(\d+)',\s*'([^']*)',\s*'([^']*)',\s*'([^']*)',\s*'(\d+)',\s*'([^']*)',\s*'(\d+)'$/siU", $out[$i][1], $insert_link);

      $insert_link[1] = trim($insert_link[1]);
      $insert_link[2] = trim($insert_link[2]);
      $insert_link[3] = trim($insert_link[3]);
      $insert_link[4] = trim($insert_link[4]);
      $insert_link[5] = trim($insert_link[5]);
      $insert_link[6] = trim($insert_link[6]);
      $insert_link[7] = trim($insert_link[7]);
      $insert_link[8] = trim($insert_link[8]);
      $insert_link[9] = trim($insert_link[9]);
      $insert_link[10] = trim($insert_link[10]);
      $insert_link[11] = trim($insert_link[11]);
      $insert_link[12] = trim($insert_link[12]);
      $insert_link[13] = trim($insert_link[13]);
      $insert_link[14] = trim($insert_link[14]);
      $insert_link[15] = trim($insert_link[15]);
      $insert_link[16] = trim($insert_link[16]);
      $insert_link[17] = trim($insert_link[17]);
      $insert_link[18] = trim($insert_link[18]);
      $insert_link[19] = trim($insert_link[19]);

      // Form SQL-query to add data
      if(!empty($insert_link[1]))
      {
         $insert[] = "INSERT INTO ".DB_LINK." VALUES (".$insert_link[1].", '".$insert_link[2]."', '".$insert_link[3]."', '".$insert_link[4]."', '".$insert_link[5]."', '".$insert_link[6]."', '".$insert_link[7]."', '".$insert_link[8]."', '".$insert_link[9]."', '".$insert_link[10]."', '".$insert_link[11]."', '".$insert_link[12]."', ".$insert_link[13].", '".$insert_link[14]."', '".$insert_link[15]."', '".$insert_link[16]."', ".$insert_link[17].", '".$insert_link[18]."', ".$insert_link[19].")";
      }
   }

   $query = "TRUNCATE TABLE ".DB_CATALOG."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $query = "TRUNCATE TABLE ".DB_LINK."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   // set true
   $create_table = true;

   // Executed queries in a cycle
   foreach($insert as $query)
   {
      $result = $dbh->query($query);

      if(!$result) { $create_table = false; }
   }

   // Close a DB connection
   $dbh->close();

   if($create_table == false) { error($MSG_ERROR_IMPORT); }
   else { back($MSG_SUCCESS_IMPORT,"backup.php",2); }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>