<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "../class/class.pager.php";
require "../class/class.pager_mysql.php";
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/edit.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   // Authenticate
   require "../lib/authenticate.inc";

   // Check variable transferred by the method GET
   if(!preg_match("|^[\d]*$|",$_GET['id_at'])) exit();
   if(!preg_match("|^[\d]*$|",$_GET['logic'])) exit();
   if(!preg_match("|^[\d]*$|",$_GET['page'])) exit();
   if(!preg_match("|^[\d]*$|",$_GET['id_catalog'])) exit();

   // Shield a special characters
   if(!get_magic_quotes_gpc())
   {
      $_GET['search'] = mysql_escape_string($_GET['search']);
      $_GET['id_cat'] = mysql_escape_string($_GET['id_at']);
      $_GET['id_catalog'] = mysql_escape_string($_GET['id_catalog']);
      $_GET['logic'] = mysql_escape_string($_GET['logic']);
   }

   $action = "";
   $action = $_POST["action"];

   if(empty($action))
   {
      // include template
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/edit.html");

      // header
      $tpl->setVariable(array('version'   => $version,
                              'title'     => $title,
                              'titlepage' => $titlepage,
                              'charset'   => $charset,
                              'VERSION'   => VERSION));

      // menu
      $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                              'ADDLINKTITLE'  => ADDLINKTITLE,
                              'CATTITLE'      => CATTITLE,
                              'CHECKTITLE'    => CHECKTITLE,
                              'EDITTITLE'     => EDITTITLE,
                              'SETTINGSTITLE' => SETTINGSTITLE,
                              'BLACKTITLE'    => BLACKTITLE,
                              'BACKUPTITLE'   => BACKUPTITLE,
                              'DESIGNTITLE'   => DESIGNTITLE,
                              'MENUINDEX'     => MENUINDEX,
                              'MENUADDURL'    => MENUADDURL,
                              'MENUCAT'       => MENUCAT,
                              'MENUCHECK'     => MENUCHECK,
                              'MENUEDIT'      => MENUEDIT,
                              'MENUSETTING'   => MENUSETTING,
                              'MENUBLACK'     => MENUBLACK,
                              'MENUCHANGE'    => MENUCHANGE,
                              'MENUBACKUP'    => MENUBACKUP,
                              'MENUDESIGN'    => MENUDESIGN));

      $tpl->setVariable(array('choosenav1' => $choosenav1,
                              'choosenav2' => $choosenav2,
                              'choosenav3' => $choosenav3,
                              'choosenav4' => $choosenav4,
                              'choosenav5' => $choosenav5,
                              'choosenav6' => $choosenav6,
                              'choosenav7' => $choosenav7,
                              'choosenav8' => $choosenav8,
                              'choosenav9' => $choosenav9,
                              'choosenav10' => $choosenav10));

      if($_GET['id_catalog'] == 0) { $slct0 = "selected"; }
      else { $slct0 = ""; }

      $_GET['search'] = urldecode($_GET['search']);

      // Print the list of catalogues
      $query = "SELECT * FROM ".DB_CATALOG." ORDER BY name";
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      $option = '';

      $array_cat = Array();
      $array_id_parent = Array();

      while($list = $result->fetch_array())
      {
         $array_cat[] = array($list['name'], $list['id_cat'],$list['id_parent']);
         $array_id_parent[] = $list['id_parent'];
      }

      // clear the discreaptor
      $result->close();

      for($i=0; $i < count($array_cat); $i++)
      {
         if($array_cat[$i][1] == $_GET['id_catalog']) { $slct = "selected"; }
         else { $slct = ""; }

         if($array_id_parent[$i] == $array_cat[$i][1])
         {
            $count_sub=0;

            for($m=0; $m < count($array_cat); $m++)
            {
               if($array_id_parent[$i] == $array_cat[$m][2])
               {
                  if($array_id_parent[$i] != $array_cat[$m][1]) $count_sub++;
               }
            }

            if($count_sub != 0)
            {
               if($_GET['id_catalog'] == $array_cat[$i][1]) { $slct = "selected"; }
               else { $slct = ""; }

               $option .= "<option value=".$array_cat[$i][1]." style=\"color: graytext;\" disabled=\"disabled\" $slct>".$array_cat[$i][0]."</option>";

               for($n=0; $n < count($array_cat); $n++)
               {
                  if($array_id_parent[$i] == $array_cat[$n][2])
                  {
                     if($array_id_parent[$i] != $array_cat[$n][1])
                     {
                        if($_GET['id_catalog'] == $array_cat[$n][1]) { $slct = "selected"; }
                        else { $slct = ""; }
                        $option .= "<option value=".$array_cat[$n][1]." style=\"color: menutext;\" $slct>&nbsp;&nbsp;&nbsp;".$array_cat[$n][0]."</option>";
                     }
                  }
               }
            }
            else
            {
               if($_GET['id_catalog'] == $array_cat[$i][1]) { $slct = "selected"; }
               else { $slct = ""; }

               $option .= "<option value=".$array_cat[$i][1]." style=\"color: menutext;\" $slct>".$array_cat[$i][0]."</option>";
            }
         }
      }

      if($_GET['logic'] == 0 OR empty($_GET['logic'])) { $logic0 = 'checked'; }
      else { $logic0 = ''; }

      if($_GET['logic'] == 1) { $logic1 = 'checked'; }
      else { $logic1 = ''; }

      // print the search form
      $tpl->setVariable(array('SEARCH'            => SEARCH,
                              'KEYWORDS'          => KEYWORDS,
                              'SEARCH_IN_CATALOG' => SEARCH_IN_CATALOG,
                              'IT_DOESNT_MATTER'  => IT_DOESNT_MATTER,
                              'MEETING_OF_KEYWORDS' => MEETING_OF_KEYWORDS,
                              'AT_LEAST_ONCE'     => AT_LEAST_ONCE,
                              'ALL_WORDS_TOGETHER'  => ALL_WORDS_TOGETHER,
                              'FIND'              => FIND));

      $tpl->setVariable(array('search' => $_GET['search'],
                              'slct0' => $slct0,
                              'option' => $option,
                              'logic0' => $logic0,
                              'logic1' => $logic1));

      // Element of pagination
      if(empty($settings['all_number_link'])) { $all_number_link = 5; }
      else { $all_number_link = $settings['all_number_link']; }

      $page = $_GET['page'];
      if(empty($page)) $page = 1;
      $begin = ($page - 1)*$all_number_link;

      // Print the list of catalogues and subcatalogues
      $query = "SELECT * FROM ".DB_CATALOG." ORDER BY name";
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      while($row = $result->fetch_array())
      {
         if($row['id_cat'] == $row['id_parent']) { $arraycat[] = array($row['name'],$row['id_cat']); }
      }

      $total = count($arraycat);
      $number = (int)($total/$settings['stl']);

      if((float)($total/$settings['stl']) - $number != 0) $number++;

      // Form an array
      for($i=0; $i<$number; $i++)
      {
         for($j=0; $j<$settings['stl']; $j++)
         {
            $arr[$i][$j] = $arraycat[$j*$number + $i];
         }
      }

      $list_cat = "<table width=\"100%\">";

      for($i = 0; $i < $number; $i++)
      {
         echo "<tr>";

         for($j = 0; $j < $settings['stl']; $j++)
         {
            if($arr[$i][$j][0])
            {
               $query2 = "SELECT * FROM ".DB_CATALOG." WHERE id_parent = ".$arr[$i][$j][1]." ORDER BY name";
               $result2 = $dbh->query($query2);

               if($result2->num_rows == 1)
               {
                  $tlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_cat=".$arr[$i][$j][1];

                  $query3 = "SELECT COUNT(*) FROM ".DB_LINK." WHERE id_cat = ".$arr[$i][$j][1]." AND hide = 'show'";
                  $result3 = $dbh->query($query3);
                  $total = $result3->fetch_assoc();

                  // Clear the descriptor
                  $result3->close();

                  $list_cat .= "<td><table border=\"0\">
                  <tr><td><img border=\"0\" src=\"images/folder.gif\"></td>
                  <td><p><a href=\"$tlink\">{$arr[$i][$j][0]}</a>&nbsp;[{$total['COUNT(*)']}]</p></td>
                  </tr>
                  </table></td>";
               }
               else
               {
                  $list_cat .= "<td><table border=\"0\">
                  <tr><td><img border=\"0\" src=\"images/folder.gif\"></td>
                  <td><p>{$arr[$i][$j][0]}</p></td></tr>";

                  while($row = $result2->fetch_array())
                  {
                     if($row['id_cat'] != $arr[$i][$j][1])
                     {
                        $query3 = "SELECT COUNT(*) FROM ".DB_LINK." WHERE id_cat = ".$row['id_cat']." AND hide = 'show'";
                        $result3 = $dbh->query($query3);
                        $total = $result3->fetch_assoc();

                        // Clear the descriptor
                        $result3->close();

                        $list_cat .= "<tr><td></td>";
                        $list_cat .= "<td><p><a href=\"http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_cat=".$row['id_cat']."\">".$row['name']."</a>&nbsp;[".$total['COUNT(*)']."]</p></td></tr>";
                     }
                  }

                  $list_cat .= '</table></td>';
               }

               // Clear the descriptor
               $result2->close();
            }
         }

         $list_cat .= '</tr>';
      }

      $list_cat .= '</table>';

      $tpl->setVariable(array('list_cat' => $list_cat));

      // Clear the descriptor
      $result->close();

      if(!empty($_GET['id_cat']) AND empty($_GET['search']))
      {
         $query = "SELECT * FROM ".DB_CATALOG." WHERE id_cat = ".$_GET['id_cat'];
         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

         if($result->num_rows > 0)
         {
            $name = $result->fetch_array();

            $tpl->setVariable(array('id_cat_name' => $name['name']));

            // Print the links
            $show_link = new pager_mysql("".DB_LINK."",
                                         "WHERE id_cat = ".$_GET['id_cat']." AND hide = 'show'",
                                         "ORDER BY time DESC ");

            $show_link->pnumber = $all_number_link;
            $show_link->parameters = $dbh;

            $arr = $show_link->get_page();

            if(is_array($arr))
            {
               $notlinks = '';
               $tpl->setVariable(array('bottom_pagination' => $show_link->print_page()));
               $tpl->setVariable(array('top_pagination'    => $show_link->print_page()));
               $tpl->setVariable(array('PAGES' => PAGES));

               for($i=0; $i<count($arr); $i++)
               {
                  $view_link['time'] = $arr[$i]['time'];
                  $view_link['count'] = $arr[$i]['count'];
                  $view_link['id_link'] = $arr[$i]['id_link'];

                  if(!empty($arr[$i]['htmlcode_link'])) { $view_link['htmlcode_link'] = "<p>{$arr[$i]['htmlcode_link']}</p>"; }
                  else { $view_link['htmlcode_link'] = "<p><a href=\"http://{$arr[$i]['url']}\" target=_blank>{$arr[$i]['name']}</a> - ".nl2br($arr[$i]['description_link'])."</p>"; }

                  if(!empty($arr[$i]['htmlcode_banner'])) { $view_link['htmlcode_banner'] = $arr[$i]['htmlcode_banner']; }
                  else { $view_link['htmlcode_banner'] = "<a href=\"http://{$arr[$i]['url']}\" target=_blank><img border=\"0\" width=\"88\" height=\"31\" src=\"../images/notimage.gif\"></a>"; }

                  if($settings['show_pr'] == "yes") { $view_link['show_pr'] = "<iframe src=\"show_pr.php?url={$arr[$i]['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"100\" height=\"50\"></iframe>"; }
                  else { $view_link['show_pr'] = ''; }

                  if($settings['show_cy'] == "yes") { $view_link['show_cy'] = "<iframe src=\"show_cy.php?url={$arr[$i]['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
                  else { $view_link['show_cy'] = ''; }

                  $view_link['button1'] = "<form action=\"editlink.php?id_link={$arr[$i]['id_link']}&page=".$_GET['page']."\" method=post>
                  <input type=submit class=\"inputsubmit\" value=\"$STR_BUTTON_EDIT\">
                  <input type=hidden name=\"id_link\" value=\"{$arr[$i]['id_link']}\"></form>";

                  $view_link['button2'] = "<form action=\"edit.php?id_cat=".$_GET['id_cat']."&page=".$_GET['page']."\" method=post>
                  <input type=submit class=\"inputsubmit\" value=\"$STR_BUTTON_DELETE\">
                  <input type=hidden name=\"id_link\" value=\"{$arr[$i]['id_link']}\">
                  <input type=hidden name=\"action\" value=\"post\"></form>";

                  $tpl->setVariable(array('ADDED' => ADDED,
                                          'NUMBER_OF_CLICKS' => NUMBER_OF_CLICKS));

                  $tpl->setVariable(array(
                  'htmlcode_banner' => $view_link['htmlcode_banner'],
                  'htmlcode_link'   => $view_link['htmlcode_link'],
                  'time'            => $view_link['time'],
                  'id_link'         => $view_link['id_link'],
                  'count'           => $view_link['count'],
                  'show_pr'         => $view_link['show_pr'],
                  'show_cy'         => $view_link['show_cy'],
                  'button1'         => $view_link['button1'],
                  'button2'         => $view_link['button2']));

                  $tpl->parse('id_cat_row_links');
               }
            }
            else { $notlinks = "<br /><p align=center class=msg>$MSG_NOTLINKS</p><br />"; }

            $tpl->setVariable(array('id_cat_notlinks' => $notlinks));
         }

         $tpl->parse('id_cat');
         $tpl->parse('bottom_id_cat_pagination');
         $tpl->parse('top_id_cat_pagination');

         // Clear the descriptor
         $result->close();
      }

      // Print the result of search
      if(!empty($_GET['search']))
      {
         $tpl->setVariable(array('name_title_searchresult' => $STR_TITLE_SEARCHRESULT));

         $search = stripslashes(trim(urldecode($_GET['search'])));

         if(strlen($search)>=3)
         {
            $search_quantity_char = '';
            $temp = strtok($search," ");
            $temp = "$temp*";

            if($_GET['logic'] == 1) { $logstr = "and"; }
            else { $logstr = "or"; }

            if($_GET['id_catalog'] == 0) $tmp2 = "AND hide = 'show'";
            else $tmp2 = "AND hide = 'show' AND id_cat = ".$_GET['id_catalog'];

            while ($temp)
            {
               if($is_query) $tmp1 .= " $logstr MATCH (name,description_link,url,full_description_link,email,htmlcode_link,kwdlink) AGAINST ('$temp' IN BOOLEAN MODE) $tmp2";
               else  $tmp1 .= "MATCH (name,description_link,url,full_description_link,email,htmlcode_link,kwdlink) AGAINST ('$temp' IN BOOLEAN MODE) $tmp2";

               $is_query = true;
               $temp = strtok(" ");
            }

            $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE $tmp1";
            $result = $dbh->query($query);

            if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

            $total = $result->fetch_assoc();

            // Clear the descriptor
            $result->close();

            $number = intval(($total['COUNT(*)'] - 1) / $all_number_link) + 1;

            if($page != 1) $pervpage = '<a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page=1>&lt;&lt; </a>
                                        <a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page - 1).'>&lt; </a> ';

            // Form the links of pagination
            if($page != $number) $nextpage = '<a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page + 1).'> &gt;</a>
                                              <a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.$number.'> &gt;&gt;</a>';

            // Form the links of pagination
            if($page - 2 > 0) $page2left = '<a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page - 2).'>...'.($page - 2).'</a> | ';
            if($page - 1 > 0) $page1left = '<a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page - 1).'>'.($page - 1).'</a> | ';
            if($page + 2 <= $number) $page2right = ' | <a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page + 2).'>'.($page + 2).'...</a>';
            if($page + 1 <= $number) $page1right = ' | <a href='.$_SERVER[PHP_SELF].'?search='.urlencode($_GET['search']).'&id_catalog='.$_GET['id_catalog'].'&logic='.$_GET['logic'].'&page='.($page + 1).'>'.($page + 1).'</a>';

            $query = "SELECT * FROM ".DB_LINK."
                      WHERE $tmp1
                      GROUP BY id_link
                      ORDER BY time DESC
                      LIMIT $begin, $all_number_link";

            $result = $dbh->query($query);

            if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

            if($result->num_rows > 0)
            {
               $tpl->setVariable(array('LINKS' => LINKS,
                                       'PAGES' => PAGES));

               $search_notfound = '';

               $tpl->setVariable(array('top_search_total_count' => $total['COUNT(*)'],
                                       'top_search_pervpage'    => $pervpage,
                                       'top_search_page2left'   => $page2left,
                                       'top_search_page1left'   => $page1left,
                                       'top_search_page'        => $page,
                                       'top_search_page1right'  => $page1right,
                                       'top_search_page2right'  => $page2right,
                                       'top_search_nextpage'    => $nextpage));

               $tpl->setVariable(array('bottom_search_total_count' => $total['COUNT(*)'],
                                       'bottom_search_pervpage'    => $pervpage,
                                       'bottom_search_page2left'   => $page2left,
                                       'bottom_search_page1left'   => $page1left,
                                       'bottom_search_page'        => $page,
                                       'bottom_search_page1right'  => $page1right,
                                       'bottom_search_page2right'  => $page2right,
                                       'bottom_search_nextpage'    => $nextpage));

               while($links = $result->fetch_array())
               {
                  $query = "SELECT name FROM ".DB_CATALOG." WHERE id_cat = ".$links['id_cat'];
                  $result2 = $dbh->query($query2);
                  $name = $result2->fetch_array();

                  //  
                  $result2->close();

                  $view_link['time'] = $links['time'];
                  $view_link['count'] = $links['count'];
                  $view_link['id_link'] = $links['id_link'];

                  if(!empty($htmlcode_link)) { $view_link['htmlcode_link'] = "<p>{$links['htmlcode_link']}</p>"; }
                  else { $view_link['htmlcode_link'] = "<p><a href=http://{$links['url']} target=_blank>{$links['name']}</a> - ".nl2br($links['description_link'])."</p>"; }

                  if(!empty($links['htmlcode_banner'])) { $view_link['htmlcode_banner'] = $links['htmlcode_banner']; }
                  else { $view_link['htmlcode_banner'] = "<a href=\"http://{$links['url']}\" target=_blank><img border=\"0\" width=\"88\" height=\"31\" src=\"../images/notimage.gif\"></a>"; }

                  if($settings['show_pr'] == "yes") { $view_link['show_pr'] = "<iframe src=\"show_pr.php?url={$links['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"100\" height=\"50\"></iframe>"; }
                  else { $view_link['show_pr'] = ''; }

                  if($settings['show_cy'] == "yes") { $view_link['show_cy'] = "<iframe src=\"show_cy.php?url={$links['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
                  else { $view_link['show_cy'] = ''; }

                  $view_link['button1'] = "<form action=\"editlink.php?id_link={$links['id_cat']}&page={$_GET['page']}\" method=post>
                  <input type=submit class=\"inputsubmit\" value=\"$STR_BUTTON_EDIT\">
                  <input type=hidden name=\"id_link\" value=\"{$links['id_link']}\"></form>";

                  $view_link['button2'] = "<form action=\"edit.php?id_cat={$links['id_cat']}&page={$_GET['page']}\" method=post>
                  <input type=submit class=\"inputsubmit\" value=\"$STR_BUTTON_DELETE\">
                  <input type=hidden name=\"id_link\" value=\"{$links['id_link']}\">
                  <input type=hidden name=\"action\" value=\"post\"></form>";

                  $tpl->setVariable(array('ADDED' => ADDED,
                                          'NUMBER_OF_CLICKS' => NUMBER_OF_CLICKS));

                  $tpl->setVariable(array('htmlcode_banner' => $view_link['htmlcode_banner'],
                                          'htmlcode_link'   => $view_link['htmlcode_link'],
                                          'time'            => $view_link['time'],
                                          'id_link'         => $view_link['id_link'],
                                          'count'           => $view_link['count'],
                                          'show_pr'         => $view_link['show_pr'],
                                          'show_cy'         => $view_link['show_cy'],
                                          'button1'         => $view_link['button1'],
                                          'button2'         => $view_link['button2']));

                  $tpl->parse('search_row_links');
               }
            }
            else
            {
               $search_notfound = "<br /><p align=center class=msg>$MSG_NOT_FOUND</p><br />";
            }

            $tpl->setVariable(array('search_notfound' => $search_notfound));

            // Clear the descriptor
            $result->close();
         }
         else
         {
            $search_quantity_char = "<br /><p align=center class=msg>$MSG_SEARCH_QUANTITY</p><br />";
         }

         $tpl->setVariable(array('search_quantity_characters' => $search_quantity_char));

         $tpl->parse('search');
         $tpl->parse('bottom_search_pagination');
         $tpl->parse('top_search_pagination');
      }

      // Count a quantity of the links
      $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
      $result = $dbh->query($query);
      $total = $result->fetch_assoc();

      // Clear the descriptor
      $result->close();

      if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
      else $LOGO = LOGO;

      // footer
      $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                              'help'        => $help,
                              'AUTHOR'      => AUTHOR,
                              'LOGO'        => $LOGO,
                              'WEBSITE'     => WEBSITE,
                              'HELPPAGE'    => HELPPAGE,
                              'FAQPAGE'     => FAQPAGE,
                              'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

      // print html page
      $tpl->show();
   }

   if(!empty($action))
   {
      // Form SQL query on remove the link
      $delete = "DELETE FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];

      if($dbh->query($delete))
      {
         // Return to the main page if a query was is executed successfully
         back($MSG_REMOVE_LINK,"edit.php?id_cat=".$_GET['id_cat']."&page=".$_GET['page'],2);
      }
      else { throw new ExceptionMySQL($dbh->error,$delete,"Error executing SQL query!"); }
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>