<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/design.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   // Authenticate
   require "../lib/authenticate.inc";

   $action = "";
   $action = $_POST["action"];

   if(empty($action))
   {
      // Read the contents of file of style.css in the buffer
      $fd = @fopen("../style/style.css", "r");
      $bufer1 = @fread($fd, filesize("../style/style.css"));
      fclose($fd);

      // Read the contents of file of top.html in the buffer
      $fd = @fopen("../templates/header.html", "r");
      $bufer2 = @fread($fd, filesize("../templates/header.html"));
      fclose($fd);

      $bufer2 = preg_replace('/{(\w+)}/sU', "[\\1]", $bufer2);

      // Read the contents of file of bottom.html in the buffer
      $fd = @fopen("../templates/footer.html", "r");
      $bufer3 = @fread($fd, filesize("../templates/footer.html"));
      fclose($fd);

      $bufer3 = preg_replace('/{(\w+)}/sU', "[\\1]", $bufer3);

      // Read the contents of file of links.html in the buffer
      $fd = @fopen("../templates/links.html", "r");
      $bufer4 = @fread($fd, filesize("../templates/links.html"));
      fclose($fd);

      $bufer4 = preg_replace('/{(\w+)}/sU', "[\\1]", $bufer4);

      // Read the contents of file of links.html in the buffer
      $fd = @fopen("../templates/addurlform.html", "r");
      $bufer5 = @fread($fd, filesize("../templates/addurlform.html"));
      fclose($fd);

      $bufer5 = preg_replace('/{(\w+)}/sU', "[\\1]", $bufer5);

      // include template
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/design.html");

      // header
      $tpl->setVariable(array('version'   => $version,
                              'title'     => $title,
                              'titlepage' => $titlepage,
                              'charset'   => $charset,
                              'VERSION'   => VERSION));

      // menu
      $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                                 'ADDLINKTITLE'  => ADDLINKTITLE,
                                 'CATTITLE'      => CATTITLE,
                                 'CHECKTITLE'    => CHECKTITLE,
                                 'EDITTITLE'     => EDITTITLE,
                                 'SETTINGSTITLE' => SETTINGSTITLE,
                                 'BLACKTITLE'    => BLACKTITLE,
                                 'BACKUPTITLE'   => BACKUPTITLE,
                                 'DESIGNTITLE'   => DESIGNTITLE,
                                 'MENUINDEX'     => MENUINDEX,
                                 'MENUADDURL'    => MENUADDURL,
                                 'MENUCAT'       => MENUCAT,
                                 'MENUCHECK'     => MENUCHECK,
                                 'MENUEDIT'      => MENUEDIT,
                                 'MENUSETTING'   => MENUSETTING,
                                 'MENUBLACK'     => MENUBLACK,
                                 'MENUCHANGE'    => MENUCHANGE,
                                 'MENUBACKUP'    => MENUBACKUP,
                                 'MENUDESIGN'    => MENUDESIGN));

      $tpl->setVariable(array('choosenav1' => $choosenav1,
                              'choosenav2' => $choosenav2,
                              'choosenav3' => $choosenav3,
                              'choosenav4' => $choosenav4,
                              'choosenav5' => $choosenav5,
                              'choosenav6' => $choosenav6,
                              'choosenav7' => $choosenav7,
                              'choosenav8' => $choosenav8,
                              'choosenav9' => $choosenav9,
                              'choosenav10' => $choosenav10));

      $bufer1 = htmlspecialchars($bufer1);
      $bufer2 = htmlspecialchars($bufer2);
      $bufer3 = htmlspecialchars($bufer3);
      $bufer4 = htmlspecialchars($bufer4);
      $bufer5 = htmlspecialchars($bufer5);

      $tpl->setVariable(array('FILE' => FILE,
                              'SAVE_CHANGES' => SAVE_CHANGES));

      $tpl->setVariable(array('bufer1' => $bufer1,
                              'bufer2' => $bufer2,
                              'bufer3' => $bufer3,
                              'bufer4' => $bufer4,
                              'bufer5' => $bufer5));

      // Count a quantity of the links
      $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
      $result = $dbh->query($query);
      $total = $result->fetch_assoc();

      // Clear the descriptor
      $result->close();

      if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
      else $LOGO = LOGO;

      // footer
      $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                              'help'        => $help,
                              'AUTHOR'      => AUTHOR,
                              'LOGO'        => $LOGO,
                              'WEBSITE'     => WEBSITE,
                              'HELPPAGE'    => HELPPAGE,
                              'FAQPAGE'     => FAQPAGE,
                              'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

      // print html page
      $tpl->show();
   }
   else
   {
      switch ($action)
      {
         case style:

           $_POST['style'] = stripslashes($_POST['style']);
           $_POST['style'] = preg_replace('/<\?(php)?/i', '', $_POST['style']);
           $_POST['style'] = preg_replace('/\?>/i', '', $_POST['style']);

           // Add changes in file style.css
           $fd = fopen("../style/style.css","w");

           fputs($fd, $_POST['style']);
           fclose($fd);

           // Return to the main page
           back($MSG_SUCCESSFLLY_CHANGE,'design.php',2);

         break;

         case header:

           $_POST['header'] = stripslashes($_POST['header']);
           $_POST['header'] = preg_replace('/<\?(php)?/i', '', $_POST['header']);
           $_POST['header'] = preg_replace('/\?>/i', '', $_POST['header']);
           $_POST['header'] = preg_replace("|\[(\w+)\]|sU", "{\\1}", $_POST['header']);

           // Add the changes in file heder.html
           $fd = fopen("../templates/header.html","w");

           fputs($fd, $_POST['header']);
           fclose($fd);

           // Return to the main page
           back($MSG_SUCCESSFLLY_CHANGE,'design.php',2);

         break;

         case links:

           $_POST['links'] = stripslashes($_POST['links']);
           $_POST['links'] = preg_replace('/<\?(php)?/i', '', $_POST['links']);
           $_POST['links'] = preg_replace('/\?>/i', '', $_POST['links']);
           $_POST['links'] = preg_replace("|\[(\w+)\]|sU", "{\\1}", $_POST['links']);

           // Add changes in file links.html
           $fd = fopen("../templates/links.html","w");

           fputs($fd, $_POST['links']);
           fclose($fd);

           // Return to the main page
           back($MSG_SUCCESSFLLY_CHANGE,'design.php',2);

         break;

         case add_url:

           $_POST['add_url'] = stripslashes($_POST['add_url']);
           $_POST['add_url'] = preg_replace('/<\?(php)?/i', '', $_POST['add_url']);
           $_POST['add_url'] = preg_replace('/\?>/i', '', $_POST['add_url']);
           $_POST['add_url'] = preg_replace("|\[(\w+)\]|sU", "{\\1}", $_POST['add_url']);

           // Add changes in file link.html
           $fd = fopen("../templates/addurlform.html","w");

           fputs($fd, $_POST['add_url']);
           fclose($fd);

           // Return to the main page
           back($MSG_SUCCESSFLLY_CHANGE,'design.php',2);

         break;

         case footer:

           $_POST['footer'] = stripslashes($_POST['footer']);
           $_POST['footer'] = preg_replace('/<\?(php)?/i', '', $_POST['footer']);
           $_POST['footer'] = preg_replace('/\?>/i', '', $_POST['footer']);
           $_POST['footer'] = preg_replace("|\[(\w+)\]|sU", "{\\1}", $_POST['footer']);

           // Add changes in file footer.html
           $fd = fopen("../templates/footer.html","w");

           fputs($fd, $_POST['footer']);
           fclose($fd);

           // Return to the main page
           back($MSG_SUCCESSFLLY_CHANGE,'design.php',2);

         break;

         default:

           // Return to the main page
           back($MSG_SUCCESSFLLY_CHANGE,'design.php',2);

         break;
      }
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>