<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "../class/class.pager.php";
require "../class/class.pager_mysql.php";
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
  // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/check_links.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   // Authenticate
   require "../lib/authenticate.inc";

   $action = "";
   $action = $_POST["action"];

   if(!empty($action))
   {
      // Add link
      switch ($_POST['event'])
      {
         case add:

           $update = "UPDATE ".DB_LINK." SET hide = 'show' WHERE id_link = ".$_POST['id_link'];

           if($dbh->query($update))
           {
              $query = "SELECT * FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];
              $result = $dbh->query($query);

              if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

              $links = $result->fetch_array();

              // Clear the descriptor
              $result->close();

              // Notify the user about his link was added
              sendMailAdd($links,$STR_SUBJECT_ADD, $_SERVER['SERVER_NAME']);

              // Return to main page if a query was executed successfully
              back($MSG_ADD_LINK, $_SERVER['PHP_SELF'],2);
           }
           else { throw new ExceptionMySQL($dbh->error,$update,"Error executing SQL query!"); }

         break;

         // Remove link
         case delete:

           $delete = "DELETE FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];

           if($dbh->query($delete))
           {
              // Return to main page if a query was executed successfully
              back($MSG_REMOVE_LINK, $_SERVER['PHP_SELF'],2);
           }
           else { throw new ExceptionMySQL($dbh->error,$delete,"Error executing SQL query!"); }

         break;

         // Add link to black list
         case black:

           $update = "UPDATE ".DB_LINK." SET hide = 'black', time = NOW(), reason = '$REASON_ADMIN' WHERE id_link = ".$_POST['id_link'];

           if($dbh->query($update))
           {
              // Return to main page if a query was executed successfully
              back($MSG_TO_BLACKLIST_LINK, $_SERVER['PHP_SELF'],2);
           }
           else { throw new ExceptionMySQL($dbh->error,$update,"Error executing SQL query!"); }

         break;

         case check_hand:

           // include template
           $tpl = new HTML_Template_Sigma('.');
           $tpl->loadTemplateFile("templates/check_form_link.html");

           // header
           $tpl->setVariable(array('version'   => $version,
                                   'title'     => $title,
                                   'titlepage' => $titlepage,
                                   'charset'   => $charset,
                                   'VERSION'   => VERSION));

           // menu
           $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                                   'ADDLINKTITLE'  => ADDLINKTITLE,
                                   'CATTITLE'      => CATTITLE,
                                   'CHECKTITLE'    => CHECKTITLE,
                                   'EDITTITLE'     => EDITTITLE,
                                   'SETTINGSTITLE' => SETTINGSTITLE,
                                   'BLACKTITLE'    => BLACKTITLE,
                                   'BACKUPTITLE'   => BACKUPTITLE,
                                   'DESIGNTITLE'   => DESIGNTITLE,
                                   'MENUINDEX'     => MENUINDEX,
                                   'MENUADDURL'    => MENUADDURL,
                                   'MENUCAT'       => MENUCAT,
                                   'MENUCHECK'     => MENUCHECK,
                                   'MENUEDIT'      => MENUEDIT,
                                   'MENUSETTING'   => MENUSETTING,
                                   'MENUBLACK'     => MENUBLACK,
                                   'MENUCHANGE'    => MENUCHANGE,
                                   'MENUBACKUP'    => MENUBACKUP,
                                   'MENUDESIGN'    => MENUDESIGN));

           $tpl->setVariable(array('choosenav1' => $choosenav1,
                                   'choosenav2' => $choosenav2,
                                   'choosenav3' => $choosenav3,
                                   'choosenav4' => $choosenav4,
                                   'choosenav5' => $choosenav5,
                                   'choosenav6' => $choosenav6,
                                   'choosenav7' => $choosenav7,
                                   'choosenav8' => $choosenav8,
                                   'choosenav9' => $choosenav9,
                                   'choosenav10' => $choosenav10));

           $query = "SELECT * FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];
           $result = $dbh->query($query);

           if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

           $links = $result->fetch_array();

           // Clear the descriptor
           $result->close();

           // Print the form of link
           $query = "SELECT name FROM ".DB_CATALOG." WHERE id_cat = ".$links['id_cat'];
           $result = $dbh->query($query);
           $chapter = $result->fetch_array();

           // Clear the descriptor
           $result->close();

           if(!empty($links['htmlcode_banner'])) { $htmlcode_banner = $links['htmlcode_banner']; }
           else { $htmlcode_banner = "<a href=\"http://".$links['url']."\"><img border=\"0\" width=\"88\" height=\"31\" src=\"../images/notimage.gif\"></a>"; }

           $links['description_link'] = nl2br($links['description_link']);

           if($settings['show_pr'] == "yes") { $show_pr = "<iframe src=\"show_pr.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"100\" height=\"50\"></iframe>"; }
           else { $show_pr = ''; }

           if($settings['show_cy'] == "yes") { $show_cy = "<iframe src=\"show_cy.php?url=".$links['url']."\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
           else { $show_cy = ''; }

           if($links['hide'] == 'hide')
           {
              $button_add = "<td><form action=\"".$_SERVER['PHP_SELF']."\" method=post>
              <input type=submit value=\"$STR_BUTTON_ADD\" class=\"inputsubmit\">
              <input type=hidden name=\"id_link\" value=\"".$links['id_link']."\">
              <input type=hidden name=\"event\" value=\"add\">
              <input type=hidden name=\"action\" value=\"post\">
              </form></td>";
           }
           else { $button_add = ''; }

           $button_delete = "<td><form action=\"".$_SERVER['PHP_SELF']."\" method=post>
           <input type=submit value=\"$STR_BUTTON_DELETE\" class=\"inputsubmit\">
           <input type=hidden name=\"id_link\" value=\"".$links['id_link']."\">
           <input type=hidden name=\"event\" value=\"delete\">
           <input type=hidden name=\"action\" value=\"post\">
           </form></td>";

           $button_black = "<td><form action=\"".$_SERVER['PHP_SELF']."\" method=post>
           <input type=submit value=\"$STR_BUTTON_TO_BLACKLIST\" class=\"inputsubmit\">
           <input type=hidden name=\"id_link\" value=\"".$links['id_link']."\">
           <input type=hidden name=\"event\" value=\"black\">
           <input type=hidden name=\"action\" value=\"post\">
           </form></td>";

           // prin form check
           $tpl->setVariable(array('BACK'           => $STR_GO_BACK,
                                   'NAME_OF_WEBSITE'        => NAME_OF_WEBSITE,
                                   'DESCRIPTION_OF_WEBSITE' => DESCRIPTION_OF_WEBSITE,
                                   'RECIP_URL_LINK' => RECIP_URL_LINK,
                                   'CHAPTER'        => CHAPTER,
                                   'ADDED'          => ADDED));

           $tpl->setVariable(array('form_htmlcode_banner'  => $htmlcode_banner,
                                   'form_url'              => $links['url'],
                                   'form_name'             => $links['name'],
                                   'form_description_link' => $links['description_link'],
                                   'form_url_link'         => $links['url_link'],
                                   'form_razdel'           => $chapter['name'],
                                   'form_time'             => $links['time'],
                                   'form_show_pr'          => $show_pr,
                                   'form_show_cy'          => $show_cy,
                                   'form_button_add'       => $button_add,
                                   'form_button_delete'    => $button_delete,
                                   'form_button_black'     => $button_black));

           // Count a quantity of the links
           $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
           $result = $dbh->query($query);
           $total = $result->fetch_assoc();

           // Clear the descriptor
           $result->close();

           if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
           else $LOGO = LOGO;

           // footer
           $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                                   'help'        => $help,
                                   'AUTHOR'      => AUTHOR,
                                   'LOGO'        => $LOGO,
                                   'WEBSITE'     => WEBSITE,
                                   'HELPPAGE'    => HELPPAGE,
                                   'FAQPAGE'     => FAQPAGE,
                                   'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

           // print html page
           $tpl->show();

         break;

         case check_aut:

           $query = "SELECT * FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];
           $result = $dbh->query($query);

           if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

           $links = $result->fetch_array();

           // Clear the descriptor
           $result->close();

           $url_link = $links['url_link'];

           if(check_url_link ($url_link) == true)
           {
              if($links['hide'] == "hide")
              {
                 if($settings['black'] == "yes")
                 {
                    $query = "UPDATE ".DB_LINK." SET hide = 'black', time = NOW(), reason = '$REASON_ABSENSE_RECIPROCAL' WHERE id_link = ".$links['id_link'];
                 }
                 else
                 {
                    $query = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
                 }

                 if($dbh->query($query))
                 {
                    // Notify the user about his link was removed
                    sendmail_del_link($links,$STR_SUBJECT_DEL,$_SERVER['SERVER_NAME']);

                    // Return to the main page if a query was executed successfully
                    back('',$_SERVER["HTTP_REFERER"],0);

                 } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
              }
              else
              {
                 $query = "UPDATE ".DB_LINK." SET hide = 'hide',time_check = NOW(), reason = '$REASON_ABSENSE_RECIPROCAL' WHERE id_link = ".$links['id_link'];

                 if($dbh->query($query))
                 {
                    // Notify the user about his link was hidded
                    $nscript = strpos($_SERVER['REQUEST_URI'], "admin");
                    $root = substr($_SERVER['REQUEST_URI'], 0, $nscript);
                    $url_link_edit = "".$HTTP_HOST.$root."edir.php?id=".$links['id_link']."&key=".$links['cod']."";

                    sendmail_hide_link ($links, $url_link_edit, $STR_SUBJECT_HIDE, $_SERVER['SERVER_NAME']);

                    // Return to the main page if a query was executed successfully
                    back('',$_SERVER["HTTP_REFERER"],0);

                 } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
              }
           }
           else
           {
              // Check on, whether the page of answer link is closed for index
              if(check_meta($url_link) == true)
              {
                 if($links['hide'] == "hide")
                 {
                    if($settings['black'] == "yes")
                    {
                       $query = "UPDATE ".DB_LINK." SET hide = 'black', time = NOW(), reason = '$REASON_CLOSED_FOR_INDEX_META' WHERE id_link = ".$links['id_link'];
                    }
                    else
                    {
                       $query = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
                    }

                    if($dbh->query($query))
                    {
                       // Notify the user about his link was removed
                       sendmail_del_link($links, $STR_SUBJECT_DEL, $_SERVER['SERVER_NAME']);

                       // Return to the main page if a query was executed successfully
                       back('',$_SERVER["HTTP_REFERER"],0);

                    } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
                 }
                 else
                 {
                    $query = "UPDATE ".DB_LINK." SET hide = 'hide',time_check = NOW(), reason = '$REASON_CLOSED_FOR_INDEX_META' WHERE id_link = ".$links['id_link'];

                    if($dbh->query($query))
                    {
                       // Notify the user about his link was hidded
                       $reason = $MSG_CLOSED_FOR_INDEX_META;

                       sendmail_hide_link2($links, $reason, $STR_SUBJECT_HIDE, $_SERVER['SERVER_NAME']);

                       // Return to the main page if a query was executed successfully
                       back('',$_SERVER["HTTP_REFERER"],0);

                    } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
                 }
              }
              else
              {
                 // Check on, whether the directory is closed for index
                 if(check_robots($url_link) == true)
                 {
                    if($links['hide'] == "hide")
                    {
                       if($settings['black'] == "yes")
                       {
                          $query = "UPDATE ".DB_LINK." SET hide = 'black', time = NOW(), reason = '$REASON_CLOSED_FOR_INDEX_ROBOT' WHERE id_link = ".$links['id_link'];
                       }
                       else
                       {
                          $query = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
                       }

                       if($dbh->query($query))
                       {
                          // Notify the user about his link was removed
                          sendmail_del_link($links, $STR_SUBJECT_DEL, $_SERVER['SERVER_NAME']);

                          // Return to the main page if a query was executed successfully
                          back('',$_SERVER["HTTP_REFERER"],0);

                       } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
                    }
                    else
                    {
                       $query = "UPDATE ".DB_LINK." SET hide = 'hide', time_check = NOW(), reason = '$REASON_CLOSED_FOR_INDEX_ROBOT' WHERE id_link = ".$links['id_link'];

                       if($dbh->query($query))
                       {
                          // Notify the user about his link was hidded
                          $reason = $MSG_CLOSED_FOR_INDEX_ROBOT;

                          sendmail_hide_link2($links, $reason, $STR_SUBJECT_HIDE, $_SERVER['SERVER_NAME']);

                          // Return to the main page if a query was executed successfully
                          back('',$_SERVER["HTTP_REFERER"],0);

                       } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
                    }
                 }
                 else
                 {
                    if($links['hide'] == "hide")
                    {
                       $query = "UPDATE ".DB_LINK." SET hide = 'show', time_check = NOW(), reason = '', Number_Check='0' WHERE id_link = ".$links['id_link'];

                       if($dbh->query($query))
                       {
                          // Notify the user about his link was restored
                          sendMailAdd($links, $STR_SUBJECT_ADD, $_SERVER['SERVER_NAME']);

                          // Return to the main page if a query was executed successfully
                          back('',$_SERVER["HTTP_REFERER"],0);

                       } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
                    }

                    if($links['hide'] == "show")
                    {
                       $query = "UPDATE ".DB_LINK." SET time_check = NOW(), Number_Check='0' WHERE id_link = ".$links['id_link'];

                       if($dbh->query($query))
                       {
                          // Return to the main page if a query was executed successfully
                          back('',$_SERVER["HTTP_REFERER"],0);

                       } else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
                    }
                 }
              }
           }

         break;

         case check_all_aut:

            $add = 0;
            $del = 0;
            $hide = 0;

            // Check all hidded link
            $query = "SELECT * FROM ".DB_LINK." WHERE hide = 'hide'";
            $result = $dbh->query($query);

            if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

            while($links = $result->fetch_array())
            {
               $url_link = $links['url_link'];
               $date_check = strtotime($links['time_check']);
               $interval_check = ceil((time()-$date_check)/3600/24);

               if($links['check_link'] == "yes" AND $interval_check>$settings['day'] AND $interval_check != 1)
               {
                  if(check_url_link ($url_link) == true)
                  {
                     if($settings['black'] == "yes")
                     {
                        $query2 = "UPDATE ".DB_LINK." SET hide = 'black', time = NOW(), reason = '$REASON_ABSENSE_RECIPROCAL' WHERE id_link = ".$links['id_link'];
                     }
                     else
                     {
                        $query2 = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
                     }

                     if($dbh->query($query2))
                     {
                        // Notify the user about his link was removed
                        sendmail_del_link($links, $STR_SUBJECT_DEL, $_SERVER['SERVER_NAME']);

                        // Count a quantity of the links which was removed
                        $del = $del+1;
                     }
                  }
                  else
                  {
                     // Check on, whether the page of answer link for index by metatag <meta name=robot>
                     if(check_meta($url_link,$settings) == true)
                     {
                        if($settings['black'] == "yes")
                        {
                             $query2 = "UPDATE ".DB_LINK." SET hide = 'black', time = NOW(), reason = '$REASON_CLOSED_FOR_INDEX_META' WHERE id_link = ".$links['id_link'];
                        }
                        else
                        {
                           $query2 = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
                        }

                        if($dbh->query($query2))
                        {
                           // Notify the user about his link was removed
                           sendmail_del_link($links, $STR_SUBJECT_DEL, $_SERVER['SERVER_NAME']);

                           // Count a quantity of the links which was removed
                           $del = $del+1;
                        }
                     }
                     else
                     {
                        // Check on, whether the directory with answer link is closed for index
                        if(check_robots($url_link) == true)
                        {
                           if($settings['black'] == "yes")
                           {
                              $query2 = "UPDATE ".DB_LINK." SET hide = 'black', time = NOW(), reason = '$REASON_CLOSED_FOR_INDEX_ROBOT' WHERE id_link = ".$links['id_link'];
                           }
                           else
                           {
                              $query2 = "DELETE FROM ".DB_LINK." WHERE id_link = ".$links['id_link'];
                           }

                           if($dbh->query($query2))
                           {
                              // Notify the user about his link was removed
                              sendmail_del_link($links, $STR_SUBJECT_DEL, $_SERVER['SERVER_NAME']);

                              // Count a quantity of the links which was removed
                              $del = $del+1;
                           }
                        }
                        else
                        {
                           $update = "UPDATE ".DB_LINK." SET hide = 'show', time_check = NOW(), reason = '', Number_Check = '0' WHERE id_link = ".$links['id_link'];

                           if($dbh->query($update))
                           {
                              // Notify the user about his link was restored
                              sendMailAdd($links, $STR_SUBJECT_ADD, $_SERVER['SERVER_NAME']);

                              // Count a quantity of the links which was added
                              $add = $add+1;
                           }
                        }
                     }
                  }
               }
            }

            // Clear the descriptor
            $result->close();

            // Check all other links
            $query = "SELECT * FROM ".DB_LINK." WHERE hide = 'show'";
            $result = $dbh->query($query);

            if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

            while($links = $result->fetch_array())
            {
               $url_link = $links['url_link'];
               $date_check = strtotime($links['time_check']);
               $interval_check = ceil((time()-$date_check)/3600/24);

               if($links['check_link'] == "yes" AND $interval_check > $settings['day'] AND $interval_check != 1)
               {
                  if(check_url_link ($url_link) == true)
                  {
                     if($links['Number_Check'] == $settings['Number_Check'])
                     {
                        // Form SQL-query to hide link
                        $update = "UPDATE ".DB_LINK." SET hide = 'hide', time_check = NOW(), reason = '$REASON_ABSENSE_RECIPROCAL' WHERE id_link = ".$links['id_link'];

                        if($dbh->query($update))
                        {
                           // Notify the user about his link was hidded
                           $nscript = strpos($_SERVER['REQUEST_URI'], "admin");
                           $root = substr($_SERVER['REQUEST_URI'], 0, $nscript);
                           $url_link_edit = "".$HTTP_HOST.$root."edit.php?id=".$links['id_link']."&key=".$links['cod']."";

                           sendmail_hide_link ($links, $url_link_edit, $STR_SUBJECT_HIDE, $_SERVER['SERVER_NAME']);

                           // Count a quantity of the links which was hidded
                           $hide = $hide+1;
                        }
                     }
                     else
                     {
                        $update = "UPDATE ".DB_LINK." SET time_check = NOW(), Number_Check=Number_Check+1 WHERE id_link = ".$links['id_link'];
                        $dbh->query($update);
                     }
                  }
                  else
                  {
                     // Check the page of answer link on index
                     if(check_meta($url_link) == true)
                     {
                        if($links['Number_Check'] == $settings['Number_Check'])
                        {
                           // Form SQL-query to hide link
                           $update = "UPDATE ".DB_LINK." SET hide = 'hide', time_check = NOW(), reason = '$REASON_CLOSED_FOR_INDEX_ROBOT' WHERE id_link = ".$links['id_link'];

                           if($dbh->query($update))
                           {
                              // Notify the user about the link was hidded
                              $reason = $MSG_CLOSED_FOR_INDEX_ROBOT;

                              sendmail_hide_link2($links, $reason, $STR_SUBJECT_HIDE, $_SERVER['SERVER_NAME']);

                              // Count a quantity of the links which was hidded
                              $hide = $hide+1;
                           }
                        }
                        else
                        {
                           $update = "UPDATE ".DB_LINK." SET time_check = NOW(), Number_Check=Number_Check+1 WHERE id_link = ".$links['id_link'];
                           $dbh->query($update);
                        }
                     }
                     else
                     {
                        // Check the directory is closed for index
                        if(check_robots($url_link) == true)
                        {
                           if($links['Number_Check'] == $settings['Number_Check'])
                           {
                              // Form SQL-query to hide link
                              $update = "UPDATE ".DB_LINK." SET hide = 'hide', time_check = NOW(), reason = '$REASON_CLOSED_FOR_INDEX_ROBOT' WHERE id_link = ".$links['id_link'];

                              if($dbh->query($update))
                              {
                                 // Notify the user about his link was hidded
                                 $reason = "$MSG_CLOSED_FOR_INDEX_ROBOT";

                                 sendmail_hide_link2($links, $reason, $STR_SUBJECT_HIDE, $_SERVER['SERVER_NAME']);

                                 // Count a quantity of the links which was hidded
                                 $hide = $hide+1;
                              }
                           }
                           else
                           {
                              $update = "UPDATE ".DB_LINK." SET time_check = NOW(), Number_Check=Number_Check+1 WHERE id_link = ".$links['id_link'];
                              $dbh->query($update);
                           }
                        }
                        else
                        {
                           $update = "UPDATE ".DB_LINK." SET time_check = NOW(), reason = '', Number_Check = '0' WHERE id_link = ".$links['id_link'];
                           $dbh->query($update);
                        }
                     }
                  }
               }
            }

            // Clear the descriptor
            $result->close();

            // include temlate
            $tpl = new HTML_Template_Sigma('.');
            $tpl->loadTemplateFile("templates/check_links.html");

            // header
            $tpl->setVariable(array('version'   => $version,
                                    'title'     => $title,
                                    'titlepage' => $titlepage,
                                    'charset'   => $charset,
                                    'VERSION'   => VERSION));

            // menu
            $tpl->setVariable(array('GO_BACK'       => $STR_GO_BACK,
                                    'ADDLINKTITLE'  => ADDLINKTITLE,
                                    'CATTITLE'      => CATTITLE,
                                    'CHECKTITLE'    => CHECKTITLE,
                                    'EDITTITLE'     => EDITTITLE,
                                    'SETTINGSTITLE' => SETTINGSTITLE,
                                    'BLACKTITLE'    => BLACKTITLE,
                                    'BACKUPTITLE'   => BACKUPTITLE,
                                    'DESIGNTITLE'   => DESIGNTITLE,
                                    'MENUINDEX'     => MENUINDEX,
                                    'MENUADDURL'    => MENUADDURL,
                                    'MENUCAT'       => MENUCAT,
                                    'MENUCHECK'     => MENUCHECK,
                                    'MENUEDIT'      => MENUEDIT,
                                    'MENUSETTING'   => MENUSETTING,
                                    'MENUBLACK'     => MENUBLACK,
                                    'MENUCHANGE'    => MENUCHANGE,
                                    'MENUBACKUP'    => MENUBACKUP,
                                    'MENUDESIGN'    => MENUDESIGN));

            $tpl->setVariable(array('choosenav1' => $choosenav1,
                                    'choosenav2' => $choosenav2,
                                    'choosenav3' => $choosenav3,
                                    'choosenav4' => $choosenav4,
                                    'choosenav5' => $choosenav5,
                                    'choosenav6' => $choosenav6,
                                    'choosenav7' => $choosenav7,
                                    'choosenav8' => $choosenav8,
                                    'choosenav9' => $choosenav9,
                                    'choosenav10' => $choosenav10));

            $tpl->setVariable(array('add'  => $add,
                                    'del'  => $del,
                                    'hide' => $hide));

             $tpl->setVariable(array('REMOVED_LINKS' => REMOVED_LINKS,
                                     'HIDDED_LINKS'  => HIDDED_LINKS,
                                     'ADDED_LINKS'   => ADDED_LINKS));

            $tpl->parse('statistics');

            // Count a quantity of the links
            $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
            $result = $dbh->query($query);
            $total = $result->fetch_assoc();

            // Clear the descriptor
            $result->close();

            if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
            else $LOGO = LOGO;

            // footer
            $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                                    'help'        => $help,
                                    'AUTHOR'      => AUTHOR,
                                    'LOGO'        => $LOGO,
                                    'WEBSITE'     => WEBSITE,
                                    'HELPPAGE'    => HELPPAGE,
                                    'FAQPAGE'     => FAQPAGE,
                                    'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

            // print html page
            $tpl->show();

         break;

         default:

            // Return to the main page if a query was executed successfully
            back('',$_SERVER["HTTP_REFERER"],0);

         break;
      }
   }
   else
   {
      // include temlate
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/check_links.html");

      // header
      $tpl->setVariable(array('version'   => $version,
                              'title'     => $title,
                              'titlepage' => $titlepage,
                              'charset'   => $charset,
                              'VERSION'   => VERSION));

      // menu
      $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                              'ADDLINKTITLE'  => ADDLINKTITLE,
                              'CATTITLE'      => CATTITLE,
                              'CHECKTITLE'    => CHECKTITLE,
                              'EDITTITLE'     => EDITTITLE,
                              'SETTINGSTITLE' => SETTINGSTITLE,
                              'BLACKTITLE'    => BLACKTITLE,
                              'BACKUPTITLE'   => BACKUPTITLE,
                              'DESIGNTITLE'   => DESIGNTITLE,
                              'MENUINDEX'     => MENUINDEX,
                              'MENUADDURL'    => MENUADDURL,
                              'MENUCAT'       => MENUCAT,
                              'MENUCHECK'     => MENUCHECK,
                              'MENUEDIT'      => MENUEDIT,
                              'MENUSETTING'   => MENUSETTING,
                              'MENUBLACK'     => MENUBLACK,
                              'MENUCHANGE'    => MENUCHANGE,
                              'MENUBACKUP'    => MENUBACKUP,
                              'MENUDESIGN'    => MENUDESIGN));

      $tpl->setVariable(array('choosenav1' => $choosenav1,
                              'choosenav2' => $choosenav2,
                              'choosenav3' => $choosenav3,
                              'choosenav4' => $choosenav4,
                              'choosenav5' => $choosenav5,
                              'choosenav6' => $choosenav6,
                              'choosenav7' => $choosenav7,
                              'choosenav8' => $choosenav8,
                              'choosenav9' => $choosenav9,
                              'choosenav10' => $choosenav10));

      // Elements of navipage
      if(empty($settings['all_number_link'])) { $all_number_link = 5; }
      else { $all_number_link = $settings['all_number_link']; }

      // Print the list of catalogues and subcatalogues
      $query = "SELECT * FROM ".DB_CATALOG." ORDER BY name";
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      while($row = $result->fetch_array())
      {
         if($row['id_cat'] == $row['id_parent']) { $arraycat[] = array($row['name'],$row['id_cat']); }
      }

      $total = count($arraycat);
      $number = (int)($total/$settings['stl']);

      if((float)($total/$settings['stl']) - $number != 0) $number++;

      // Form an array
      for($i=0; $i<$number; $i++)
      {
         for($j=0; $j<$settings['stl']; $j++)
         {
            $arr[$i][$j] = $arraycat[$j*$number + $i];
         }
      }

      $list_cat = "<table width=\"100%\">";

      for($i = 0; $i < $number; $i++)
      {
         echo "<tr>";

         for($j = 0; $j < $settings['stl']; $j++)
         {
            if($arr[$i][$j][0])
            {
               $query2 = "SELECT * FROM ".DB_CATALOG." WHERE id_parent = ".$arr[$i][$j][1]." ORDER BY name";
               $result2 = $dbh->query($query2);

               if($result2->num_rows == 1)
               {
                  $tlink = "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_cat=".$arr[$i][$j][1];

                  $query3 = "SELECT COUNT(*) FROM ".DB_LINK." WHERE id_cat = ".$arr[$i][$j][1]." AND hide = 'show'";
                  $result3 = $dbh->query($query3);
                  $total = $result3->fetch_assoc();

                  // Clear the descriptor
                  $result3->close();

                  $list_cat .= "<td><table border=\"0\">
                  <tr><td><img border=\"0\" src=\"images/folder.gif\"></td>
                  <td><p><a href=\"$tlink\">{$arr[$i][$j][0]}</a>&nbsp;[{$total['COUNT(*)']}]</p></td>
                  </tr>
                  </table></td>";
               }
               else
               {
                  $list_cat .= "<td><table border=\"0\">
                  <tr><td><img border=\"0\" src=\"images/folder.gif\"></td>
                  <td>{$arr[$i][$j][0]}</td></tr>";

                  while($row = $result2->fetch_array())
                  {
                     if($row['id_cat'] != $arr[$i][$j][1])
                     {
                        $query3 = "SELECT COUNT(*) FROM ".DB_LINK." WHERE id_cat = ".$row['id_cat']." AND hide = 'show'";
                        $result3 = $dbh->query($query3);
                        $total = $result3->fetch_assoc();

                        // Clear the descriptor
                        $result3->close();

                        $list_cat .= "<tr><td></td>";
                        $list_cat .= "<td><p><a href=http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']."?id_cat=".$row['id_cat'].">".$row['name']."</a>&nbsp;[".$total['COUNT(*)']."]</p></td></tr>";
                     }
                  }

                  $list_cat .= '</table></td>';
               }

               // Clear the descriptor
               $result2->close();
            }
         }

         $list_cat .= '</tr>';
      }

      $list_cat .= '</table>';

      // Clear the descriptor
      $result->close();

      $tpl->setVariable(array('list_cat' => $list_cat,
                              'php_self' => $_SERVER['PHP_SELF']));

      if(!empty($_GET['id_cat']))
      {
         $tpl->setVariable(array('CHECK_ALL_LINKS_AUTOMATICALLY' => CHECK_ALL_LINKS_AUTOMATICALLY,
                                 'LINKS_WAITING_CHECKS' => LINKS_WAITING_CHECKS));

         $query = "SELECT * FROM ".DB_CATALOG." WHERE id_cat = ".$_GET['id_cat'];
         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

         if($result->num_rows > 0)
         {
            $category = $result->fetch_array();

            $tpl->setVariable(array('category_name' => $category['name']));

            // Print link
            $show_link = new pager_mysql("".DB_LINK."",
                                         "WHERE id_cat = ".$_GET['id_cat']." AND hide = 'show'",
                                         "ORDER BY time DESC");

            $show_link->pnumber = $all_number_link;
            $show_link->parameters = $dbh;
            $arr = $show_link->get_page();

            if(is_array($arr))
            {
               $notlinks = '';

               $tpl->setVariable(array('bottom_show_navipage' => $show_link->print_page()));
               $tpl->setVariable(array('top_show_navipage'    => $show_link->print_page()));
               $tpl->setVariable(array('PAGES' => PAGES));

               for($i=0; $i<count($arr); $i++)
               {
                  $date_check = strtotime($arr[$i]['time_check']);
                  $interval_check = ceil((time()-$date_check)/3600/24);

                  $view_link['time'] = $arr[$i]['time'];
                  $view_link['count'] = $arr[$i]['count'];
                  $view_link['id_link'] = $arr[$i]['id_link'];

                  if($interval_check == 1) { $alert='onclick="alert(\''.$MSG_ALERT_WAS_CHECKED.'\'); return false;"'; }
                  else { $alert = ""; }

                  if(!empty($arr[$i]['htmlcode_link'])) { $view_link['htmlcode_link'] = "<p>{$arr[$i]['htmlcode_link']}</p>"; }
                  else { $view_link['htmlcode_link'] = "<p><a href=\"http://{$arr[$i]['url']}\" target=_blank>{$arr[$i]['name']}</a> - ".nl2br($arr[$i]['description_link'])."</p>"; }

                  if(!empty($arr[$i]['htmlcode_banner'])) { $view_link['htmlcode_banner'] = $arr[$i]['htmlcode_banner']; }
                  else { $view_link['htmlcode_banner'] = "<a href=\"http://{$arr[$i]['url']}\" target=_blank><img border=\"0\" width=\"88\" height=\"31\" src=\"../images/notimage.gif\"></a>"; }

                  if($settings['show_pr'] == "yes") { $view_link['show_pr'] = "<iframe src=\"show_pr.php?url={$arr[$i]['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"100\" height=\"50\"></iframe>"; }
                  else { $view_link['show_pr'] = ''; }

                  if($settings['show_cy'] == "yes") { $view_link['show_cy'] = "<iframe src=\"show_cy.php?url={$arr[$i]['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
                  else { $view_link['show_cy'] = ''; }

                  if($arr[$i]['check_link'] == "yes" OR !empty($arr[$i]['url_link']))
                  {
                     $view_link['button2'] = "<form action=\"".$_SERVER['PHP_SELF']."\" method=post>
                     <input type=submit value=\"$STR_BUTTON_AUTOCHECK\" $alert class=\"inputsubmit\">
                     <input type=hidden name=\"id_link\" value=\"{$view_link['id_link']}\">
                     <input type=hidden name=\"event\" value=\"check_aut\">
                     <input type=hidden name=\"action\" value=\"post\"></form>";
                  }
                  else { $view_link['button2'] = ''; }

                  if(empty($arr[$i]['url_link'])) { $view_link['button1'] = $view_link['button2']; $view_link['button2'] = ''; }
                  else
                  {
                     $view_link['button1'] = "<form action=\"".$_SERVER['PHP_SELF']."\" method=post>
                     <input type=submit value=\"$STR_BUTTON_HANDCHECK\" class=\"inputsubmit\">
                     <input type=hidden name=\"id_link\" value=\"{$view_link['id_link']}\">
                     <input type=hidden name=\"event\" value=\"check_hand\">
                     <input type=hidden name=\"action\" value=\"post\"></form>";
                  }

                  $tpl->setVariable(array('ADDED' => ADDED,
                                          'NUMBER_OF_CLICKS' => NUMBER_OF_CLICKS));

                  $tpl->setVariable(array('htmlcode_banner' => $view_link['htmlcode_banner'],
                                          'htmlcode_link'   => $view_link['htmlcode_link'],
                                          'time'            => $view_link['time'],
                                          'id_link'         => $view_link['id_link'],
                                          'count'           => $view_link['count'],
                                          'show_pr'         => $view_link['show_pr'],
                                          'show_cy'         => $view_link['show_cy'],
                                          'button1'         => $view_link['button1'],
                                          'button2'         => $view_link['button2']));

                  $tpl->parse('show_row_links');
               }
            }
            else
            {
               $notlinks = "<br /><p class=msg align=center>$MSG_NOTLINKS</p><br />";
            }

            $tpl->setVariable(array('notlinks' => $notlinks));
         }

         $tpl->parse('show');
         $tpl->parse('bottom_show_pagination');
         $tpl->parse('top_show_pagination');
      }
      else
      {
         $tpl->setVariable(array('CHECK_ALL_LINKS_AUTOMATICALLY' => CHECK_ALL_LINKS_AUTOMATICALLY,
                                 'LINKS_FOR_CHECKS' => LINKS_FOR_CHECKS));

         // Print the link
         $show_link = new pager_mysql("".DB_LINK."",
                                      "WHERE hide = 'hide'",
                                      "ORDER BY time DESC");

         $show_link->pnumber = $all_number_link;
         $show_link->parameters = $dbh;

         $arr = $show_link->get_page();

         if(is_array($arr))
         {
            $notlinks = '';

            $tpl->setVariable(array('top_hide_navipage'    => $show_link->print_page()));
            $tpl->setVariable(array('bottom_hide_navipage' => $show_link->print_page()));
            $tpl->setVariable(array('PAGES' => PAGES));

            for($i=0; $i<count($arr); $i++)
            {
               $date_check = strtotime($arr[$i]['time_check']);
               $interval_check = ceil((time()-$date_check)/3600/24);

               $view_link['time'] = $arr[$i]['time'];
               $view_link['count'] = $arr[$i]['count'];
               $view_link['id_link'] = $arr[$i]['id_link'];

               if($interval_check == 1) { $alert='onclick="alert(\''.$MSG_ALERT_WAS_CHECKED.'\'); return false;"'; }
               else { $alert = ""; }

               if(!empty($arr[$i]['htmlcode_link'])) { $view_link['htmlcode_link'] = "<p>{$arr[$i]['htmlcode_link']}</p>"; }
               else { $view_link['htmlcode_link'] = "<p><a href=\"http://{$arr[$i]['url']}\" target=_blank>{$arr[$i]['name']}</a> - ".nl2br($arr[$i]['description_link'])."</p>"; }

               if(!empty($arr[$i]['htmlcode_banner'])) { $view_link['htmlcode_banner'] = $arr[$i]['htmlcode_banner']; }
               else { $view_link['htmlcode_banner'] = "<a href=\"http://{$arr[$i]['url']}\" target=_blank><img border=\"0\" width=\"88\" height=\"31\" src=\"../images/notimage.gif\"></a>"; }

               if($settings['show_pr'] == "yes") { $view_link['show_pr'] = "<iframe src=\"show_pr.php?url={$arr[$i]['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"100\" height=\"50\"></iframe>"; }
               else { $view_link['show_pr'] = ''; }

               if($settings['show_cy'] == "yes") { $view_link['show_cy'] = "<iframe src=\"show_cy.php?url={$arr[$i]['url']}\" frameborder=\"0\" scrolling=\"no\" width=\"125\" height=\"50\"></iframe>"; }
               else { $view_link['show_cy'] = ''; }

               if($arr[$i]['check_link'] == "yes" OR !empty($arr[$i]['url_link']))
               {
                  $view_link['button2'] = "<form action=\"".$_SERVER['PHP_SELF']."\" method=post>
                  <input type=submit value=\"$STR_BUTTON_AUTOCHECK\" $alert class=\"inputsubmit\">
                  <input type=hidden name=\"id_link\" value=\"{$view_link['id_link']}\">
                  <input type=hidden name=\"event\" value=\"check_aut\">
                  <input type=hidden name=\"action\" value=\"post\"></form>";
               }
               else { $view_link['button2'] = ''; }

               if(empty($arr[$i]['url_link'])) { $view_link['button1'] = $view_link['button2']; $view_link['button2'] = ''; }
               else
               {
                  $view_link['button1'] = "<form action=\"".$_SERVER['PHP_SELF']."\" method=post>
                  <input type=submit value=\"$STR_BUTTON_HANDCHECK\" class=\"inputsubmit\">
                  <input type=hidden name=\"id_link\" value=\"{$view_link['id_link']}\">
                  <input type=hidden name=\"event\" value=\"check_hand\">
                  <input type=hidden name=\"action\" value=\"post\"></form>";
               }

               $tpl->setVariable(array('ADDED'            => ADDED,
                                       'NUMBER_OF_CLICKS' => NUMBER_OF_CLICKS));

               $tpl->setVariable(array('htmlcode_banner' => $view_link['htmlcode_banner'],
                                       'htmlcode_link'   => $view_link['htmlcode_link'],
                                       'time'            => $view_link['time'],
                                       'id_link'         => $view_link['id_link'],
                                       'count'           => $view_link['count'],
                                       'show_pr'         => $view_link['show_pr'],
                                       'show_cy'         => $view_link['show_cy'],
                                       'button1'         => $view_link['button1'],
                                       'button2'         => $view_link['button2']));

               $tpl->parse('hide_row_links');
            }
         }
         else
         {
            $notlinks = "<br /><p class=msg align=center>$MSG_NOTLINKS</p><br />";
         }

         $tpl->setVariable(array('hide_notlinks' => $notlinks));

         $tpl->parse('hide');
         $tpl->parse('bottom_hide_pagination');
         $tpl->parse('top_hide_pagination');
      }

      // Count a quantity of the links
      $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
      $result = $dbh->query($query);
      $total = $result->fetch_assoc();

      // Clear the descriptor
      $result->close();

      if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
      else $LOGO = LOGO;

      // footer
      $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                              'help'        => $help,
                              'AUTHOR'      => AUTHOR,
                              'LOGO'        => $LOGO,
                              'WEBSITE'     => WEBSITE,
                              'HELPPAGE'    => HELPPAGE,
                              'FAQPAGE'     => FAQPAGE,
                              'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

      // print html page
      $tpl->show();
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>