<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // Authenticate
   require "../lib/authenticate.inc";

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/change.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   $_POST['current_password'] = trim($_POST['current_password']);
   $_POST['password'] = trim($_POST['password']);
   $_POST['password_again'] = trim($_POST['password_again']);

   $error = "";

   $action = "";
   $action = $_POST["action"];

   if(!empty($action))
   {
      $current_password = md5($_POST['current_password']);

      // Check all input data on valid
      if(empty($_POST['current_password']))
      {
         $action = "";
         $error = $error."<li>$MSG_ERROR_FILL_CURRENTPASS</li>";
      }

      if(!empty($_POST['current_password']))
      {
         if($passw_aut != $current_password)
         {
            $action = "";
            $error = $error."<li>$MSG_ERROR_CURRENTPASS</li>";
         }
      }

      if(empty($_POST['password']))
      {
         $action = "";
         $error = $error."<li>$MSG_ERROR_FILL_PASS</li>";
      }

      if(empty($_POST['password_again']))
      {
         $action = "";
         $error = $error."<li>$MSG_ERROR_FILL_AGAIN_PASS</li>";
      }

      if(!empty($_POST['password']) and !empty($_POST['password_again']))
      {
         if($_POST['password'] != $_POST['password_again'])
         {
            $action = "";
            $error = $error."<li>$MSG_ERROR_COINCIDE_PASS</li>";
         }
      }

      if(empty($error))
      {
         // Get hash of the password
         $password = md5(trim($_POST["password"]));

         // Form the SQL query on update
         $query = "UPDATE ".DB_AUT." SET passw='$password'";

         if($dbh->query($query))
         {
           // Print the notice if a query is executed successfully
           include "nulltop.php";

           echo "<a href=\"change.php\">$STR_GO_BACK</a><br>";
           echo "<p align=center class=msg>$MSG_SUCCESS_CHANGE</p><br /><br />";

           include "nullbottom.php";

           exit();
         }
         else { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
      }
   }

   if(empty($action))
   {
      // include template
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/change.html");

      // header
      $tpl->setVariable(array('version'   => $version,
                              'title'     => $title,
                              'titlepage' => $titlepage,
                              'charset'   => $charset,
                              'VERSION'   => VERSION));

      // menu
      $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                              'ADDLINKTITLE'  => ADDLINKTITLE,
                              'CATTITLE'      => CATTITLE,
                              'CHECKTITLE'    => CHECKTITLE,
                              'EDITTITLE'     => EDITTITLE,
                              'SETTINGSTITLE' => SETTINGSTITLE,
                              'BLACKTITLE'    => BLACKTITLE,
                              'BACKUPTITLE'   => BACKUPTITLE,
                              'DESIGNTITLE'   => DESIGNTITLE,
                              'MENUINDEX'     => MENUINDEX,
                              'MENUADDURL'    => MENUADDURL,
                              'MENUCAT'       => MENUCAT,
                              'MENUCHECK'     => MENUCHECK,
                              'MENUEDIT'      => MENUEDIT,
                              'MENUSETTING'   => MENUSETTING,
                              'MENUBLACK'     => MENUBLACK,
                              'MENUCHANGE'    => MENUCHANGE,
                              'MENUBACKUP'    => MENUBACKUP,
                              'MENUDESIGN'    => MENUDESIGN));

      $tpl->setVariable(array('choosenav1' => $choosenav1,
                              'choosenav2' => $choosenav2,
                              'choosenav3' => $choosenav3,
                              'choosenav4' => $choosenav4,
                              'choosenav5' => $choosenav5,
                              'choosenav6' => $choosenav6,
                              'choosenav7' => $choosenav7,
                              'choosenav8' => $choosenav8,
                              'choosenav9' => $choosenav9,
                              'choosenav10' => $choosenav10));

      $tpl->setVariable(array('php_self'           => $_SERVER['PHP_SELF'],
                              'PLEASE_ENTER_NEW_PASSWORD' => PLEASE_ENTER_NEW_PASSWORD,
                              'CURRENT_PASSWORD'   => CURRENT_PASSWORD,
                              'NEW_PASSWORD'       => NEW_PASSWORD,
                              'NEW_PASSWORD_AGAIN' => NEW_PASSWORD_AGAIN,
                              'SAVE'               => SAVE));

      // Report an errors
      if(!empty($error))
      {
         //
         $tpl->setVariable(array('error' => $error,
                                 'PRINT_TITLE_ERROR' => PRINT_TITLE_ERROR));

         $tpl->parse('msg_error');
      }

      // Count a quantity of the links
      $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
      $result = $dbh->query($query);
      $total = $result->fetch_assoc();

      // Clear the descriptor
      $result->close();

      if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
      else $LOGO = LOGO;

      // footer
      $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                              'help'        => $help,
                              'AUTHOR'      => AUTHOR,
                              'LOGO'        => $LOGO,
                              'WEBSITE'     => WEBSITE,
                              'HELPPAGE'    => HELPPAGE,
                              'FAQPAGE'     => FAQPAGE,
                              'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

      // print html page
      $tpl->show();
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>