<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Shield a special characters
if(!get_magic_quotes_gpc())
{
   $_GET['id_parent'] = mysql_escape_string($_GET['id_parent']);
}

// Require necessary classes
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/category.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   // Authenticate
   require "../lib/authenticate.inc";

   // include template
   $tpl = new HTML_Template_Sigma('.');
   $tpl->loadTemplateFile("templates/category.html");

   // header
   $tpl->setVariable(array('version'   => $version,
                           'title'     => $title,
                           'titlepage' => $titlepage,
                           'charset'   => $charset,
                           'VERSION'   => VERSION));

   // menu
   $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                           'ADDLINKTITLE'  => ADDLINKTITLE,
                           'CATTITLE'      => CATTITLE,
                           'CHECKTITLE'    => CHECKTITLE,
                           'EDITTITLE'     => EDITTITLE,
                           'SETTINGSTITLE' => SETTINGSTITLE,
                           'BLACKTITLE'    => BLACKTITLE,
                           'BACKUPTITLE'   => BACKUPTITLE,
                           'DESIGNTITLE'   => DESIGNTITLE,
                           'MENUINDEX'     => MENUINDEX,
                           'MENUADDURL'    => MENUADDURL,
                           'MENUCAT'       => MENUCAT,
                           'MENUCHECK'     => MENUCHECK,
                           'MENUEDIT'      => MENUEDIT,
                           'MENUSETTING'   => MENUSETTING,
                           'MENUBLACK'     => MENUBLACK,
                           'MENUCHANGE'    => MENUCHANGE,
                           'MENUBACKUP'    => MENUBACKUP,
                           'MENUDESIGN'    => MENUDESIGN));

   $tpl->setVariable(array('choosenav1' => $choosenav1,
                           'choosenav2' => $choosenav2,
                           'choosenav3' => $choosenav3,
                           'choosenav4' => $choosenav4,
                           'choosenav5' => $choosenav5,
                           'choosenav6' => $choosenav6,
                           'choosenav7' => $choosenav7,
                           'choosenav8' => $choosenav8,
                           'choosenav9' => $choosenav9,
                           'choosenav10' => $choosenav10));

    $tpl->setVariable(array('ADD_CATEGORY' => ADD_CATEGORY,
                            'POS'          => POS,
                            'ACTION'       => ACTION,
                            'CATEGORY'     => CATEGORY));

   // Print a list of catalogue
   $query = "SELECT * FROM ".DB_CATALOG." ORDER BY name";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $array_cat = Array();
   $array_id_parent = Array();

   while($list = $result->fetch_array())
   {
      $array_cat[] = array($list['name'], $list['id_cat'],$list['id_parent']);
      $array_id_parent[] = $list['id_parent'];
   }

   // Clear the descriptor
   $result->close();

   $n = 0;

   for($i=0; $i < count($array_cat); $i++)
   {
      if($array_id_parent[$i] == $array_cat[$i][1])
      {
         $count_sub=0;

         for($m=0; $m < count($array_cat); $m++)
         {
            if($array_id_parent[$i] == $array_cat[$m][2])
            {
               if($array_id_parent[$i] != $array_cat[$m][1]) $count_sub++;
            }
         }

         $n++;

         if($count_sub != 0)
         {
             $tpl->setVariable(array('n'         => $n,
                                     'id_parent' => $array_id_parent[$i],
                                     'name_cat'  => $array_cat[$i][0],
                                     'id_cat'    => $array_cat[$i][1],
                                     'EDIT'      => EDIT,
                                     'REMOVE'    => REMOVE));

             $tpl->parse('row_cat1');
         }
         else
         {
            $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE id_cat = ".$array_cat[$i][1]." AND hide = 'show'";
            $result = $dbh->query($query);
            $total = $result->fetch_assoc();

            // Clear the descriptor
            $result->close();

            if($total['COUNT(*)']>0)
            {
               $alert='onclick="return confirm(\''.$MSG_ALERT_DEL_LINK.'\');"';
            }
            else
            {
               $alert='';
            }

            $tpl->setVariable(array('n'           => $n,
                                    'id_parent'   => $array_id_parent[$i],
                                    'name_cat'    => $array_cat[$i][0],
                                    'total_links' => $total['COUNT(*)'],
                                    'alert'       => $alert,
                                    'id_cat'      => $array_cat[$i][1],
                                    'EDIT'        => EDIT,
                                    'REMOVE'      => REMOVE));

            $tpl->parse('row_cat2');
         }
      }
   }

   if($_GET['id_parent'])
   {
      // Find out a name of the parental catalogue
      $query = "SELECT * FROM ".DB_CATALOG." WHERE id_parent=".$_GET['id_parent']." ORDER BY name";
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      while($row = $result->fetch_array())
      {
         if($row['id_cat'] == $_GET['id_parent'])
         {
            $name_of_cat = $row['name'];
            break;
         }
      }

      // Clear the descriptor
      $result->close();

      $tpl->setVariable(array('name_of_cat'    => $name_of_cat,
                              'sub_id_parent'  => $_GET['id_parent'],
                              'ADDSUBCATEGORY' => ADDSUBCATEGORY,
                              'SUBCATEGORY'    => SUBCATEGORY,
                              'ACTIONSUB'         => ACTION,
                              'POSSUB'            => POS));

      // Form a list of the subcatalogues
      $query = "SELECT * FROM ".DB_CATALOG." WHERE id_parent=".$_GET['id_parent']." ORDER BY name";
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      $i=0;

      while($row = $result->fetch_array())
      {
         if($row['id_cat'] != $_GET['id_parent'])
         {
            $i++;

            $query2 = "SELECT COUNT(*) FROM ".DB_LINK." WHERE id_cat = ".$row['id_cat']." AND hide = 'show'";
            $result2 = $dbh->query($query2);
            $total = $result2->fetch_assoc();

            // Clear the descriptor
            $result2->close();

            if($total['COUNT(*)']>0)
            {
               $alert='onclick="return confirm(\''.$MSG_ALERT_DEL_LINK.'\');"';
            }
            else
            {
               $alert='';
            }

            $tpl->setVariable(array('i'          => $i,
                                     'sub_name'  => $row['name'],
                                     'sub_total' => $total['COUNT(*)'],
                                     'id_subcat' => $row['id_cat'],
                                     'subalert'  => $alert,
                                     'EDIT'      => EDIT,
                                     'REMOVE'    => REMOVE));

            $tpl->parse('row_subcat');
         }
      }

      // Clear the descriptor
      $result->close();
   }

   $tpl->parse('subcategory');

   // Count a quantity of the links
   $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
   $result = $dbh->query($query);
   $total = $result->fetch_assoc();

   // Clear the descriptor
   $result->close();

   if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
   else $LOGO = LOGO;

   // footer
   $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                           'help'        => $help,
                           'AUTHOR'      => AUTHOR,
                           'LOGO'        => $LOGO,
                           'WEBSITE'     => WEBSITE,
                           'HELPPAGE'    => HELPPAGE,
                           'FAQPAGE'     => FAQPAGE,
                           'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

   // print html page
   $tpl->show();

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>