<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "../class/class.pager.php";
require "../class/class.pager_mysql.php";
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/blacklist.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   // Authenticate
   require "../lib/authenticate.inc";

   $action = "";
   $action = $_POST["action"];

   if(!empty($action))
   {
      // Remove links
      if($_POST['event'] == "delete")
      {
         $delete = "DELETE FROM ".DB_LINK." WHERE id_link = ".$_POST['id_link'];

         if($dbh->query($delete))
         {
           // Return to back if a query is executed successfully
           back($MSG_REMOVE_LINK,$_SERVER["HTTP_REFERER"],2);
         }
         else { throw new ExceptionMySQL($dbh->error,$delete,"Error executing SQL query!"); }
      }

      if($_POST['event'] == "restore")
      {
         // From SQL query on update data
         $update = "UPDATE ".DB_LINK." SET hide = 'show', time = NOW(), Number_Check=0, reason = '' WHERE id_link = ".$_POST['id_link'];

         if($dbh->query($update))
         {
           // Return to back if a query is executed successfully
           back($MSG_RESTORE_LINK,$_SERVER["HTTP_REFERER"],2);
         }
         else { throw new ExceptionMySQL($dbh->error,$update,"Error executing SQL query!"); }
      }
   }

   if(empty($action))
   {
      // include template
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/blacklist.html");

      // header
      $tpl->setVariable(array('version'   => $version,
                              'title'     => $title,
                              'titlepage' => $titlepage,
                              'charset'   => $charset,
                              'VERSION'   => VERSION));

      // menu
      $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                              'ADDLINKTITLE'  => ADDLINKTITLE,
                              'CATTITLE'      => CATTITLE,
                              'CHECKTITLE'    => CHECKTITLE,
                              'EDITTITLE'     => EDITTITLE,
                              'SETTINGSTITLE' => SETTINGSTITLE,
                              'BLACKTITLE'    => BLACKTITLE,
                              'BACKUPTITLE'   => BACKUPTITLE,
                              'DESIGNTITLE'   => DESIGNTITLE,
                              'MENUINDEX'     => MENUINDEX,
                              'MENUADDURL'    => MENUADDURL,
                              'MENUCAT'       => MENUCAT,
                              'MENUCHECK'     => MENUCHECK,
                              'MENUEDIT'      => MENUEDIT,
                              'MENUSETTING'   => MENUSETTING,
                              'MENUBLACK'     => MENUBLACK,
                              'MENUCHANGE'    => MENUCHANGE,
                              'MENUBACKUP'    => MENUBACKUP,
                              'MENUDESIGN'    => MENUDESIGN));

      $tpl->setVariable(array('choosenav1' => $choosenav1,
                              'choosenav2' => $choosenav2,
                              'choosenav3' => $choosenav3,
                              'choosenav4' => $choosenav4,
                              'choosenav5' => $choosenav5,
                              'choosenav6' => $choosenav6,
                              'choosenav7' => $choosenav7,
                              'choosenav8' => $choosenav8,
                              'choosenav9' => $choosenav9,
                              'choosenav10' => $choosenav10));

      // Element of pagination
      if(empty($settings['all_number_link'])) { $all_number_link = 5; }
      else { $all_number_link = $settings['all_number_link']; }

      $show_link = new pager_mysql("".DB_LINK."",
                                   "WHERE hide = 'black'",
                                   "ORDER BY time DESC ");

      $show_link->pnumber = $all_number_link;
      $show_link->parameters = $dbh;

      $arr = $show_link->get_page();

      if(is_array($arr))
      {
         $notlinks = '';

         for($i=0; $i<count($arr); $i++)
         {
            // Print links
            $query = "SELECT name FROM ".DB_CATALOG." WHERE id_cat = ".$arr[$i]['id_cat'];
            $result = $dbh->query($query);

            if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

            $chapter=$result->fetch_array();

            // Clear the descriptor
            $result->close();

            $blacklink['url'] = $arr[$i]['url'];
            $blacklink['name'] = $arr[$i]['name'];
            $blacklink['description_link'] = nl2br($arr[$i]['description_link']);
            $blacklink['email'] = $arr[$i]['email'];
            $blacklink['reason'] = $arr[$i]['reason'];
            $blacklink['time'] = $arr[$i]['time'];

            $blacklink['button1'] = "<form action=\"".$_SERVER['PHP_SELF']."\" method=post>
            <input type=submit class=\"inputsubmit\" value=\"$STR_BUTTON_DELETE\">
            <input type=hidden name=\"id_link\" value=\"{$arr[$i]['id_link']}\">
            <input type=hidden name=\"event\" value=\"delete\">
            <input type=hidden name=\"action\" value=\"post\"></form>";

            $blacklink['button2'] = "<form action=\"".$_SERVER['PHP_SELF']."\" method=post>
            <input type=submit class=\"inputsubmit\" value=\"$STR_BUTTON_RESTORE\">
            <input type=hidden name=\"id_link\" value=\"{$arr[$i]['id_link']}\">
            <input type=hidden name=\"event\" value=\"restore\">
            <input type=hidden name=\"action\" value=post></form>";

            $tpl->setVariable(array('NAME_OF_WEBSITE' => NAME_OF_WEBSITE,
                                    'WEBSITE_DESCRIPTION' => WEBSITE_DESCRIPTION,
                                    'EMAIL'           => EMAIL,
                                    'CHAPTER'         => CHAPTER,
                                    'REASON'          => REASON,
                                    'BLACKLISTED'     => BLACKLISTED));

            $tpl->setVariable(array('black_url'              => $blacklink['url'],
                                    'black_name'             => $blacklink['name'],
                                    'black_description_link' => $blacklink['description_link'],
                                    'black_email'            => $blacklink['email'],
                                    'black_chapter_name'     => $chapter['name'],
                                    'black_reason'           => $blacklink['reason'],
                                    'black_time'             => $blacklink['time'],
                                    'black_button1'          => $blacklink['button1'],
                                    'black_button2'          => $blacklink['button2']));

            $tpl->parse('row_links');
         }

         // Print the pagination
         $tpl->setVariable(array('pagination' => $show_link->print_page(),
                                 'PAGES'      => PAGES));
      }
      else
      {
         $notlinks = "<p align=\"center\" class=\"msg\">$MSG_NOTLINKS</p>";
      }

      $tpl->setVariable(array('notlinks' => $notlinks));
      $tpl->parse('pagination');

      // Count a quantity of the links
      $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
      $result = $dbh->query($query);
      $total = $result->fetch_assoc();

      // Clear the descriptor
      $result->close();

      if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
      else $LOGO = LOGO;

      // footer
      $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                              'help'        => $help,
                              'AUTHOR'      => AUTHOR,
                              'LOGO'        => $LOGO,
                              'WEBSITE'     => WEBSITE,
                              'HELPPAGE'    => HELPPAGE,
                              'FAQPAGE'     => FAQPAGE,
                              'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

      // print html page
      $tpl->show();
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>