<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/backup.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   // Authenticate
   require "../lib/authenticate.inc";

   // include template
   $tpl = new HTML_Template_Sigma('.');
   $tpl->loadTemplateFile("templates/backup.html");

   // header
   $tpl->setVariable(array('version'   => $version,
                           'title'     => $title,
                           'titlepage' => $titlepage,
                           'charset'   => $charset,
                           'VERSION'   => VERSION));

   // menu
   $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                           'ADDLINKTITLE'  => ADDLINKTITLE,
                           'CATTITLE'      => CATTITLE,
                           'CHECKTITLE'    => CHECKTITLE,
                           'EDITTITLE'     => EDITTITLE,
                           'SETTINGSTITLE' => SETTINGSTITLE,
                           'BLACKTITLE'    => BLACKTITLE,
                           'BACKUPTITLE'   => BACKUPTITLE,
                           'DESIGNTITLE'   => DESIGNTITLE,
                           'MENUINDEX'     => MENUINDEX,
                           'MENUADDURL'    => MENUADDURL,
                           'MENUCAT'       => MENUCAT,
                           'MENUCHECK'     => MENUCHECK,
                           'MENUEDIT'      => MENUEDIT,
                           'MENUSETTING'   => MENUSETTING,
                           'MENUBLACK'     => MENUBLACK,
                           'MENUCHANGE'    => MENUCHANGE,
                           'MENUBACKUP'    => MENUBACKUP,
                           'MENUDESIGN'    => MENUDESIGN));

   $tpl->setVariable(array('choosenav1' => $choosenav1,
                           'choosenav2' => $choosenav2,
                           'choosenav3' => $choosenav3,
                           'choosenav4' => $choosenav4,
                           'choosenav5' => $choosenav5,
                           'choosenav6' => $choosenav6,
                           'choosenav7' => $choosenav7,
                           'choosenav8' => $choosenav8,
                           'choosenav9' => $choosenav9,
                           'choosenav10' => $choosenav10));

   if(empty($_GET['action']))
   {
      $tpl->setVariable(array('CREATE_BACKUP_OF_DATABASE'     => CREATE_BACKUP_OF_DATABASE,
                              'DOWNLOAD_PACKED_BACKUP_COPIES' => DOWNLOAD_PACKED_BACKUP_COPIES,
                              'REMOVE_BACKUP_DIR_COPIES'      => REMOVE_BACKUP_DIR_COPIES,
                              'MSG_REMOVE_BACKUP_COPIES'      => MSG_REMOVE_BACKUP_COPIES,
                              'IMPORT_OF_DATABASE'            => IMPORT_OF_DATABASE,
                              'IMPORT'                        => IMPORT));

      $tpl->parse('main_page');
   }
   else
   {


      switch ($_GET["action"])
      {
         case backup:

            $rnd = getRandomCod();

            chmod("backup", 0755);

            $folder = "backup/".date("d_m_Y", microtime(time()));
            $makefolder = @mkdir($folder, 0755);
            $result_t = $dbh->query("show tables;");

            $prs_bar = "<p class=msg>";

            // Find out what tables exist
            $zapros_table = "";
            $string_query = "";

            $header_dump = "--\r\n";
            $header_dump .= "-- Dump of My Links Manager\r\n";
            $header_dump .= "-- version $version\r\n";
            $header_dump .= "-- http://janicky.com\r\n";
            $header_dump .= "--\r\n\r\n";

            while($tables = $result_t->fetch_array())
            {
               $prim_k = "";
               $query_t_struc = $dbh->query("DESCRIBE ".$tables['Tables_in_'.$db_name].";");
               $query = "\r\n--\r-- Structure of the table `".$tables['Tables_in_'.$db_name]."`\r--\r\n\r\ncreate table ".$tables['Tables_in_'.$db_name]." (";

               // Choose only those tables from the DB which belong to the catalogue
               if("".DB_AUT."" == $tables['Tables_in_'.$db_name] OR "".DB_LINK."" == $tables['Tables_in_'.$db_name] OR "".DB_CATALOG."" == $tables['Tables_in_'.$db_name] OR "".DB_SETTING."" == $tables['Tables_in_'.$db_name])
               {
                  // Next create a query on restore values of fields in this table
                  // Choose all values from the table
                  $table_name = $tables['Tables_in_'.$db_name];
                  $result = $dbh->query("DESCRIBE ".$table_name.";");
                  $column_num = 0;

                  // Count the number of cells in the table
                  // If the cell is a field such as datetime or text then conclude their in inverted commas like as: ", 'value',"
                  while($describe = $result->fetch_array())
                  {
                     if($describe[1] == "datetime" || $describe[1] == "text") $kav[$column_num] = 1;
                     else $kav[$column_num] = 0;

                     $column_num++;
                  }

                  // Clear the descriptor
                  $result->close();

                  // Form a query for printing all values
                  $result_column = $dbh->query("select * from ".$table_name.";");
                  $result = $dbh->query("select count(*) from ".$table_name.";");
                  $count_row = $result->fetch_array();

                  // Clear the descriptor
                  $result->close();

                  if($count_row[0]!= 0)
                  {
                     $zapros = "";

                     // Form a query string
                     while($column = $result_column->fetch_array())
                     {
                        $column_string = "";

                        for($z = 0; $z<$column_num; $z++)
                        {
                           if($z<($column_num-1))
                           {
                              if($kav[$z] == 1) $column_string = $column_string."'".$column[$z]."', ";
                              else $column_string=$column_string."'".$column[$z]."', ";
                           }
                           else
                           {
                              if($kav[$z] == 1) $column_string = $column_string."'".$column[$z]."'";
                              else $column_string = $column_string."'".$column[$z]."'";
                           }
                        }

                        $zapros[] = "\r\ninsert into ".$table_name." values(".$column_string.");\r";
                     }

                     // Clear the descriptor
                     $result_column->close();

                     // Array with querys transform to one string for recording in a file
                     $string = "";

                     for($i = 0; $i<count($zapros); $i++)
                     {
                        $string = $string.$zapros[$i]."";
                     }

                     $string_query .= "--\r-- Dump of the DB `$table_name`\r--\r\n$string\r\n";
                  }

                  // Form a query for creation of the tables
                  if($query_t_struc->num_rows > 1)
                  {
                     for($i = 0; $i<$query_t_struc->num_rows; $i++)
                     {
                        if($i<($query_t_struc->num_rows-1))
                        {
                           $t_str = $query_t_struc->fetch_array();
                           $t = "";

                           if($t_str['Key'] == "PRI") $prim_k = $t_str['Field'];
                           if($t_str['Null'] == "") $t = "not null";

                           $query = $query.$t_str['Field']." ".$t_str['Type']." ".$t." ".$t_str['Extra'].", ";
                        }
                        else
                        {
                           $t_str = $query_t_struc->fetch_array();
                           $t = "";

                           if($t_str['Key'] == "PRI") $prim_k = $t_str['Field'];
                           if($t_str['Null'] == "") $t = "not null";

                           $query = $query.$t_str['Field']." ".$t_str['Type']." ".$t." ".$t_str['Extra']." ";
                        }
                     }
                  }

                  if($query_t_struc->num_rows == 1)
                  {
                     $t_str = $query_t_struc->fetch_array();
                     $t = "";

                     if($t_str['Null'] == "") $t = "not null";
                     $query = $query.$t_str['Field']." ".$t_str['Type']." ".$t." ".$t_str['Extra']."";
                  }

                  if($prim_k != "") $zapros_table = $zapros_table.$query." , Primary key (".$prim_k.")) type=myisam;\r";
                  else $zapros_table = $zapros_table.$query.") type=myisam;\r";
               }

               // Clear the descriptor
               $query_t_struc->close();
            }

            // Clear the descriptor
            $result_t->close();

            // Save a query for creation of the tables in a file dump.sql
            $zapros_table = preg_replace("/\s+,/", ",", $header_dump.$zapros_table);
            $file_t = fopen($folder."/dump.sql", 'w');

            fputs($file_t, $zapros_table);
            fputs($file_t, $string_query);

            fclose($file_t);

            // Open directory backup
            $dir = opendir("backup/");

            while($line = readdir($dir))
            {
               $packing = explode("_",$line);

               if(is_dir("backup/".$line) && $line != "." && $line != ".." && $packing[(count($packing)-1)]!= "pack")
               {
                  // open a subdirectory with a name $line and search a file
                  $dir_file = opendir("backup/".$line);

                  while($files = readdir($dir_file))
                  {
                     // If a file exist then compress it
                     if(is_file("backup/".$line."/".$files))
                     {
                        // Read contents of a file
                        $string = "";
                        $query_file = @file("backup/".$line."/".$files);

                        for($i = 0; $i<count($query_file); $i++)
                        {
                           $string = $string.$query_file[$i];
                        }

                        // Create a subdirectory
                        @mkdir("backup/".$line."_".$rnd."_pack/", 0755);

                        if(gzip_pack("backup/".$line."_".$rnd."_pack/".$files.".gz", $string) == true)
                        {
                           $MSG_PACKED = str_replace('file',"backup/".$line."_".$rnd."_pack/".$files.".gz",$MSG_PACKED);
                           $tpl->setVariable(array('alert' => $MSG_PACKED));
                        }
                        else
                        {
                           $MSG_ERROR_PACKED = str_replace('file',"backup/".$line."_".$rnd."_pack/".$files.".gz",$MSG_ERROR_PACKED);
                           $tpl->setVariable(array('alert' => $MSG_ERROR_PACKED));
                        }

                        // Delete the original of compressed file
                        @unlink("backup/".$line."/".$files);
                     }
                  }

                  closedir($dir_file);

                  // Remove the directory
                  rmdir("backup/".$line);
               }
            }

            $prs_bar .= "$MSG_READY_QUERY_CREATION ".$folder.$line."_".$rnd."_pack/dump.sql</p>";
            $prs_bar .= "<script type='text/javascript'>setTimeout(\"document.location=\\\"backup.php\\\";\",3000);</script>";

            $tpl->setVariable(array('prs_bar' => $prs_bar));
            $tpl->parse('backup');

         break;

         // Removal a dump's directory
         case remove:

            $prs_bar = "<p class=msg>";
            $dir = opendir("backup/");

            while($line = readdir($dir))
            {
               if(is_dir("backup/".$line) && $line != "." && $line!="..")
               {
                  if(remove_dir("backup/".$line))
                  {
                     $MSG_REMOVE_DIR = str_replace('dir',"backup/".$line,$MSG_REMOVE_DIR);
                     $tpl->setVariable(array('alert' => $MSG_REMOVE_DIR));
                  }
                  else
                  {
                     $MSG_ERROR_REMOVE_DIR = str_replace('dir',"backup/".$line,$MSG_ERROR_REMOVE_DIRR);
                     $tpl->setVariable(array('alert' => $MSG_ERROR_REMOVE_DIR));
                  }
               }
            }

            $prs_bar .= "<br /><script type='text/javascript'>setTimeout(\"document.location=\\\"backup.php\\\";\",3000);</script>";

            $tpl->setVariable(array('prs_bar' => $prs_bar));

            $tpl->parse('remove');

         break;

         case download:

            $prs_bar = '';

            // Read contents of a directory backup
            $dir = opendir("backup/");

            while($line = readdir($dir))
            {
               $packing = explode("_",$line);

               if(is_dir("backup/".$line) && $line != "." && $line != ".." && $packing[(count($packing)-1)] == "pack")
               {
                  preg_match("/(\d{2})_(\d{2})_(\d{4})\w+_pack/", $line, $date);

                  $prs_bar .= "<h5><hr align=left width='40%'>$STR_LINK_DIRECTORY_BACKUP <i>backup/".$line."/</i><br />
                  $STR_DATE_CREATION <i>".$date[1].".".$date[2].".".$date[3]."</i></h5>";

                  // Open a subdirectory with a name $line and search for files
                  $dir_file = opendir("backup/".$line);

                  while($files = readdir($dir_file))
                  {
                     // Print the list of a file if they exist
                     if(is_file("backup/".$line."/".$files)) $prs_bar .= "<a href='backup/".$line."/".$files."' title=\"$STR_LINK_HELP\">".$files."</a>\n<br />\n";
                  }

                  $prs_bar .= "<br />";

                  closedir($dir_file);
               }
            }

            $tpl->setVariable(array('prs_bar' => $prs_bar,
                                    'GO_BACK' => $STR_GO_BACK));

            $tpl->parse('download');

         break;

         default:

            // Return to the main page if a query was executed successfully
            back('','backup.php',0);

         break;
      }
   }

   // Count a quantity of the links
   $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
   $result = $dbh->query($query);
   $total = $result->fetch_assoc();

   // Clear the descriptor
   $result->close();

   if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
   else $LOGO = LOGO;

   // footer
   $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                           'help'        => $help,
                           'AUTHOR'      => AUTHOR,
                           'LOGO'        => $LOGO,
                           'WEBSITE'     => WEBSITE,
                           'HELPPAGE'    => HELPPAGE,
                           'FAQPAGE'     => FAQPAGE,
                           'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

   // print html page
   $tpl->show();

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>