<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require necessary classes
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require necessary libs
require_once "../lib/connect.inc";
require_once "../lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/addlink.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   // Authenticate
   require "../lib/authenticate.inc";

   $error = Array();

   $error[1] = "";
   $error[2] = "";
   $error[3] = "";
   $error[4] = "";
   $error[5] = "";
   $error[6] = "";
   $error[7] = "";
   $error[8] = "";

   $action = "";
   $action = $_POST["action"];

   if(!empty($action))
   {
      // Cut out a tags and a blanks
      $_POST["name"] = stripslashes(trim(htmlspecialchars($_POST["name"])));
      $_POST["email"] = strtolower(trim($_POST["email"]));
      $_POST["kwdlink"] = strtolower(trim($_POST["kwdlink"]));
      $_POST["description_link"] = stripslashes(trim(htmlspecialchars($_POST["description_link"])));
      $_POST["full_description_link"] = stripslashes(trim(htmlspecialchars($_POST["full_description_link"])));
      $_POST["url"] = strtolower(trim($_POST["url"]));
      $_POST["url_link"] = trim($_POST["url_link"]);
      $_POST["htmlcode_link"] = stripslashes(trim($_POST["htmlcode_link"]));
      $_POST["htmlcode_banner"] = stripslashes(trim($_POST["htmlcode_banner"]));

      if($_POST['check_link'] == "on") { $_POST['check_link'] = "yes"; }
      else { $_POST['check_link'] = "no"; }

      // Cut out http:// from url of site
      if(!empty($_POST["url"]))
      {
         if(substr($_POST["url"], 0, 7) == "http://") { $_POST["url"] = str_replace('http://','',$_POST["url"]); }
         if(strpos($_POST["url"],'/')>0) { list($_POST["url"]) = explode('/',$_POST["url"]); }
      }

      // Cut out http:// from url address of reciprocal link
      if(!empty($_POST["url_link"]))
      {
         if(substr(strtolower($_POST["url_link"]), 0, 7) == "http://") { $_POST["url_link"] = str_replace('http://','',$_POST["url_link"]); }
      }

      // Cut out all unnecessary tags and javascripts from HTML code of link
      $_POST["htmlcode_link"] = cuttags($_POST["htmlcode_link"]);

      // Cut out all unnecessary tags and javascripts from HTML code of banner
      $_POST["htmlcode_banner"] = cuttags($_POST["htmlcode_banner"]);

      // Check catalogue already has adding link, if it has then print error
      if(!empty($_POST["url"]))
      {
         $src_url = $_POST["url"];

         if(substr($_POST["url"], 0, 4) == "www.") { $src_url = str_replace('www.','',$src_url); }
         $src_url = str_replace('.','\\.',$src_url);

         $query = "SELECT * FROM ".DB_LINK." WHERE url RLIKE '^(www\\.)?$src_url$' AND hide = 'show' OR
                                                   url RLIKE '^(www\\.)?$src_url$' AND hide = 'black'";

         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,"Error executing SQL query!"); }
         if($result->num_rows > 0)
         {
            $action = "";
            $error[3] = $error[3]." $MSG_ERROR_ERRORALREADY_EXISTS";
         }

         // Clear the descriptor
         $result->close();

         $query = "SELECT * FROM ".DB_LINK." WHERE url RLIKE '^(www\\.)?$src_url$' AND hide = 'new' OR
                                                   url RLIKE '^(www\\.)?$src_url$' AND hide = 'hide'";

         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
         if($result->num_rows > 0)
         {
            $action = "";
            $error[3] = $error[3]." $MSG_ERROR_WAIT_VERIFICATION";
         }

         // Clear the descriptor
         $result->close();
      }

      // Check category is chosen, if not then print error
      if($_POST["id_cat"] == 0)
      {
         $action = "";
         $error[1] = $error[1]." $MSG_ERROR_CHOOSE_CATEGORY";
      }

      // Check the url on valid
      if(!empty($_POST["url"]))
      {
         if(check_url($_POST["url"]) == true)
         {
            $action = "";
            $error[3] = $error[3]." $MSG_ERROR_WRONG_URL";
         }
      }

      // Check on, whether the adding site on the same hosting as catalogue is located
      if(!empty($_POST["url"]) and $settings['common_host'] == "yes")
      {
         if(common_host ($_POST["url"]) == true)
         {
            $action = "";
            $error[3] = $error[3]." $MSG_ERROR_SAME_HOSTING";
         }
      }

      // Check email on valid
      if(!empty($_POST["email"]))
      {
         if(check_email($_POST["email"]) == true)
         {
            $action = "";
            $error[4] = $error[4]." $MSG_ERROR_WRONG_EMAIL";
         }
      }

      // Check brief description of site on spaces
      if(!empty($_POST["description_link"]))
      {
         if(len_description($_POST["description_link"]) == true)
         {
            $action = "";
            $error[5] = $error[5]." $MSG_ERROR_SHORT_DESC_WITHOUT_SPACES";
         }
      }

      // Check full description of site on a quantity of characters
      if(!empty($_POST["full_description_link"]))
      {
         if(len_description($_POST["full_description_link"]) == true)
         {
            $action = "";
            $error[6] = $error[6]." $MSG_ERROR_FULL_DESC_WITHOUT_SPACES";
         }
      }

      // Check HTML code of link on valid
      if(!empty($_POST["htmlcode_link"]))
      {
         if(check_htmlcode_link($_POST["htmlcode_link"]) == true)
         {
            $action = "";
            $error[7] = $error[7]." $MSG_ERROR_WRONG_HTML_LINK";
         }
      }

      // Check HTML code of banner on valid
      if(!empty($_POST["htmlcode_banner"]))
      {
         // check htmlcode of banner
         if(check_htmlcode_banner($_POST["htmlcode_banner"]) == true)
         {
            $action = "";
            $error[8] = $error[8]." $MSG_ERROR_WRONG_HTML_BANNER";
         }
         else
         {
            // check image size of banner
            if(check_size_banner($_POST["htmlcode_banner"]) == true)
            {
               $action = "";
               $error[8] = $error[8]." $MSG_ERROR_SIZE_BANNER";
            }

            // check image type of banner
            if(check_type_image_banner($_POST["htmlcode_banner"]) == true)
            {
               $action = "";
               $error[8] = $error[8]." $MSG_ERROR_EXEND_BANNER";
            }
         }
      }

      // Check all required fields is filled
      // Check site name, if its value is empty print error
      if(empty($_POST["name"]))
      {
         $action = "";
         $error[2] = $error[2]." $MSG_ERROR_NOFILL_NAME ";
      }

      // Check site address, if its value is empty print error
      if(empty($_POST["url"]))
      {
         $action = "";
         $error[3] = $error[3]." $MSG_ERROR_NOFILL_URL ";
      }

      // Check reciprocal link, if its value is empty print error
      if(empty($_POST["description_link"]))
      {
         $action = "";
         $error[5] = $error[5]." $MSG_ERROR_NOFILL_BRIEFDESC ";
      }

      // Check email, if its value is empty print error
      if(empty($_POST["full_description_link"]))
      {
         $action = "";
         $error[6] = $error[6]." $MSG_ERROR_NOFILL_FULLDESC ";
      }

      // Shield a special characters
      if(!get_magic_quotes_gpc())
      {
         $_POST["name"]  = mysql_escape_string($_POST["name"]);
         $_POST["email"]  = mysql_escape_string($_POST["email"]);
         $_POST["kwdlink"]  = mysql_escape_string($_POST["kwdlink"]);
         $_POST["url"]  = mysql_escape_string($_POST["url"]);
         $_POST["url_link"]  = mysql_escape_string($_POST["url_link"]);
         $_POST["description_link"]  = mysql_escape_string($_POST["description_link"]);
         $_POST["full_description_link"] = mysql_escape_string($_POST["full_description_link"]);
         $_POST["htmlcode_link"] = mysql_escape_string($_POST["htmlcode_link"]);
         $_POST["htmlcode_banner"] = mysql_escape_string($_POST["htmlcode_banner"]);
         $_POST["id_cat"] = mysql_escape_string($_POST["id_cat"]);
      }

      $error[1] = trim($error[1]);
      $error[2] = trim($error[2]);
      $error[3] = trim($error[3]);
      $error[4] = trim($error[4]);
      $error[5] = trim($error[5]);
      $error[6] = trim($error[6]);
      $error[7] = trim($error[7]);
      $error[8] = trim($error[8]);

      // Add the link if not any errors
      if(empty($error[1]) and empty($error[2]) and empty($error[3]) and empty($error[4]) and empty($error[5]) and empty($error[6]) and empty($error[7]) and empty($error[8]))
      {
         $cod = getRandomCod();

         // Form the SQL query on the adding of link
         $insert = "INSERT INTO ".DB_LINK." VALUES (0,
                                                   '".$_POST['name']."',
                                                   '".$_POST['url']."',
                                                   '".$_POST['url_link']."',
                                                   NOW(),
                                                   '0000-00-00 00:00:00',
                                                   '".$_POST["email"]."',
                                                   '".$_POST["kwdlink"]."',
                                                   '".$_POST["description_link"]."',
                                                   '".$_POST["full_description_link"]."',
                                                   '".$_POST["htmlcode_link"]."',
                                                   '".$_POST["htmlcode_banner"]."',
                                                   '".$_POST['id_cat']."',
                                                   'show',
                                                   '$cod',
                                                   '".$_POST['check_link']."',
                                                   0,
                                                   '',
                                                   0);";

         $result = $dbh->prepare($insert);

         if($result)
         {
            $result->execute();

            // Return to the main page if a SQL query is executed successfully
            back($MSG_ADD_LINK,'addlink.php',2);
         }
         else { throw new ExceptionMySQL($dbh->error,$insert,"Error executing SQL query!"); }
      }
   }

   if(empty($action))
   {
      // include template
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/addlink.html");

      // header
      $tpl->setVariable(array('version'   => $version,
                              'title'     => $title,
                              'titlepage' => $titlepage,
                              'charset'   => $charset,
                              'VERSION'   => VERSION));

      // menu
      $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                              'ADDLINKTITLE'  => ADDLINKTITLE,
                              'CATTITLE'      => CATTITLE,
                              'CHECKTITLE'    => CHECKTITLE,
                              'EDITTITLE'     => EDITTITLE,
                              'SETTINGSTITLE' => SETTINGSTITLE,
                              'BLACKTITLE'    => BLACKTITLE,
                              'BACKUPTITLE'   => BACKUPTITLE,
                              'DESIGNTITLE'   => DESIGNTITLE,
                              'MENUINDEX'     => MENUINDEX,
                              'MENUADDURL'    => MENUADDURL,
                              'MENUCAT'       => MENUCAT,
                              'MENUCHECK'     => MENUCHECK,
                              'MENUEDIT'      => MENUEDIT,
                              'MENUSETTING'   => MENUSETTING,
                              'MENUBLACK'     => MENUBLACK,
                              'MENUCHANGE'    => MENUCHANGE,
                              'MENUBACKUP'    => MENUBACKUP,
                              'MENUDESIGN'    => MENUDESIGN));

      $tpl->setVariable(array('choosenav1' => $choosenav1,
                              'choosenav2' => $choosenav2,
                              'choosenav3' => $choosenav3,
                              'choosenav4' => $choosenav4,
                              'choosenav5' => $choosenav5,
                              'choosenav6' => $choosenav6,
                              'choosenav7' => $choosenav7,
                              'choosenav8' => $choosenav8,
                              'choosenav9' => $choosenav9,
                              'choosenav10' => $choosenav10));

      // print errors
      $tpl->setVariable(array('error1' => $error[1],
                              'error2' => $error[2],
                              'error3' => $error[3],
                              'error4' => $error[4],
                              'error5' => $error[5],
                              'error6' => $error[6],
                              'error7' => $error[7],
                              'error8' => $error[8]));

      $action_url = "addlink.php";
      $hidden_field = "";

      $check_box = "checked";

      if($_POST['check_link'] == "yes") { $check_box = "checked"; }
      if($_POST['check_link'] == "no") { $check_box = ""; }

      $query = "SELECT * FROM ".DB_CATALOG." ORDER BY name";
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      if($_POST['id_cat'] == 0) { $slct0 = "selected"; }
      else { $slct0 = ""; }

      $option = '';
      $arraycat = Array();
      $array_id_parent = Array();

      while($list = $result->fetch_array())
      {
         $arraycat[] = array($list['name'], $list['id_cat'],$list['id_parent']);
         $array_id_parent[] = $list['id_parent'];
      }

      for($i=0; $i < count($arraycat); $i++)
      {
         if($arraycat[$i][1] == $_POST['id_cat']) { $slct = "selected"; }
         else { $slct = ""; }

         if($array_id_parent[$i] == $arraycat[$i][1])
         {
            $count_sub=0;

            for($m=0; $m < count($arraycat); $m++)
            {
               if($array_id_parent[$i] == $arraycat[$m][2])
               {
                  if($array_id_parent[$i] != $arraycat[$m][1]) $count_sub++;
               }
            }

            if($count_sub != 0)
            {
               $option .= "<option value=".$arraycat[$i][1]." style=\"color: graytext;\" disabled=\"disabled\">".$arraycat[$i][0]."</option>\r\n";

               for($n=0; $n < count($arraycat); $n++)
               {
                  if($array_id_parent[$i] == $arraycat[$n][2])
                  {
                     if($array_id_parent[$i] != $arraycat[$n][1])
                     {
                        if($_POST['id_cat'] == $arraycat[$n][1]) { $slct = "selected"; }
                        else { $slct = ""; }

                        $option .= "<option value=".$arraycat[$n][1]." style=\"color: menutext;\" $slct>&nbsp;&nbsp;&nbsp;".$arraycat[$n][0]."</option>\r\n";
                     }
                  }
               }
            }
            else
            {
               $option .= "<option value=".$arraycat[$i][1]." style=\"color: menutext;\" $slct>".$arraycat[$i][0]."</option>\r\n";
            }
         }
      }

      // Clear the descriptor
      $result->close();

      // print form
       $tpl->setVariable(array('REQUIRED_FIELDS' => REQUIRED_FIELDS,
                               'CATEGORY'        => CATEGORY,
                               'CHOOSE_CATEGORY' => CHOOSE_CATEGORY,
                               'WEBSITE_NAME'    => WEBSITE_NAME,
                               'URL'             => URL,
                               'ADDRESS_OF_RECIP_LINK_PAGE' => ADDRESS_OF_RECIP_LINK_PAGE,
                               'EMAIL'           => EMAIL,
                               'KEYWORDS'        => KEYWORDS,
                               'LIST_SEPARATED_BY_COMMAS' => LIST_SEPARATED_BY_COMMAS,
                               'BRIEF_DESCRIPTION_LINK'   => BRIEF_DESCRIPTION_LINK,
                               'FULL_DESCRIPTION_LINK'    => FULL_DESCRIPTION_LINK,
                               'HTML_CODE_OF_LINK'        => HTML_CODE_OF_LINK,
                               'HTML_CODE_OF_BANNER'      => HTML_CODE_OF_BANNER,
                               'TO_CHECK_THIS_LINK'       => TO_CHECK_THIS_LINK,
                               'ONLY_TEXT_NOT_HTML'       => ONLY_TEXT_NOT_HTML));

      $tpl->setVariable(array('action_url'            => $action_url,
                              'hidden_field'          => $hidden_field,
                              'slct'                  => $slct0,
                              'option'                => $option,
                              'name'                  => $_POST['name'],
                              'url'                   => $_POST['url'],
                              'url_link'              => $_POST['url_link'],
                              'email'                 => $_POST['email'],
                              'kwdlink'               => $_POST['kwdlink'],
                              'description_link'      => $_POST['description_link'],
                              'full_description_link' => $_POST['full_description_link'],
                              'htmlcode_link'         => $_POST['htmlcode_link'],
                              'htmlcode_banner'       => $_POST['htmlcode_banner'],
                              'check_box'             => $check_box,
                              'button'                => $STR_BUTTON_ADD));

      // Count a quantity of the links
      $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
      $result = $dbh->query($query);
      $total = $result->fetch_assoc();

      // Clear the descriptor
      $result->close();

      if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
      else $LOGO = LOGO;

      // footer
      $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                              'help'        => $help,
                              'AUTHOR'      => AUTHOR,
                              'LOGO'        => $LOGO,
                              'WEBSITE'     => WEBSITE,
                              'HELPPAGE'    => HELPPAGE,
                              'FAQPAGE'     => FAQPAGE,
                              'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

      // print html page
      $tpl->show();
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>