<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////

// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Require the classes
require "../class/class.exception_mysql.php";
require "../class/class.exception_object.php";
require "../class/class.exception_member.php";
require_once '../class/Sigma.php';

// Require the libs
require_once "../lib/function.inc";
require_once "../lib/connect.inc";

// Shield a special characters
if(!get_magic_quotes_gpc())
{
   $_GET['id_parent'] = mysql_escape_string($_GET['id_parent']);
}

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/addcategory.inc";
   require "templates/language/".$settings['language']."/language.inc";
   require "menu.php";

   // Authenticate
   require "../lib/authenticate.inc";

   $error = "";

   $action = "";
   $action = $_POST["action"];

   if(!empty($action))
   {
      //
      $_POST['name'] = htmlspecialchars(trim($_POST['name']));
      $_POST['description'] = trim($_POST['description']);
      $_POST['keywords'] = trim($_POST['keywords']);

      // Shield a special characters
      if(!get_magic_quotes_gpc())
      {
         $_POST['name'] = mysql_escape_string($_POST['name']);
         $_POST['description'] = mysql_escape_string($_POST['description']);
         $_POST['keywords'] = mysql_escape_string($_POST['keywords']);
         $_POST['id_parent'] = mysql_escape_string($_POST['id_parent']);
      }

      // Check empty a name of category
      if(empty($_POST['name']))
      {
         $action = "";
         $error = $MSG_ERROR_FILL_CAT_NAME;
      }

      // Check this category exist in the DB
      if(!empty($_POST['name']))
      {
         if($_POST['level'] == 'parent') { $query = "SELECT * FROM ".DB_CATALOG." WHERE name LIKE '".$_POST['name']."'"; }
         else { $query = "SELECT * FROM ".DB_CATALOG." WHERE id_parent=".$_POST['id_parent']." AND name LIKE '".$_POST['name']."'";  }

         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

         if($result->num_rows > 0)
         {
            $action = "";
            $error = $MSG_ERROR_SAME_CAT_NAME;
         }

         $result->close();
      }

      // Form SQL query on added a new category
      if(empty($error))
      {
         $insert = "INSERT INTO ".DB_CATALOG." VALUES (0,'".$_POST['name']."','".$_POST['description']."','".$_POST['keywords']."',".$_POST['id_parent'].");";
         $result = $dbh->prepare($insert);

         if($result)
         {
            $result->execute();

            // Close a DB connection
            $dbh->close();

            if($_POST['level'] == 'parent') { $url = "category.php"; }
            else { $url = "category.php?id_parent=".$_POST['id_parent'].""; }

            // Return to main page if query is executed successfully
            back($MSG_ADD_NEW_CATEGORY,$url,2);
         }
         else
         {
            throw new ExceptionMySQL($dbh->error,$insert,"Error executing SQL query!");
         }
      }
   }

   if(empty($action))
   {
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/addcategory.html");

      // header
      $tpl->setVariable(array('version'   => $version,
                              'title'     => $title,
                              'titlepage' => $titlepage,
                              'charset'   => $charset,
                              'VERSION'   => VERSION));

      // menu
      $tpl->setVariable(array('INDEXTITLE'    => INDEXTITLE,
                                 'ADDLINKTITLE'  => ADDLINKTITLE,
                                 'CATTITLE'      => CATTITLE,
                                 'CHECKTITLE'    => CHECKTITLE,
                                 'EDITTITLE'     => EDITTITLE,
                                 'SETTINGSTITLE' => SETTINGSTITLE,
                                 'BLACKTITLE'    => BLACKTITLE,
                                 'BACKUPTITLE'   => BACKUPTITLE,
                                 'DESIGNTITLE'   => DESIGNTITLE,
                                 'MENUINDEX'     => MENUINDEX,
                                 'MENUADDURL'    => MENUADDURL,
                                 'MENUCAT'       => MENUCAT,
                                 'MENUCHECK'     => MENUCHECK,
                                 'MENUEDIT'      => MENUEDIT,
                                 'MENUSETTING'   => MENUSETTING,
                                 'MENUBLACK'     => MENUBLACK,
                                 'MENUCHANGE'    => MENUCHANGE,
                                 'MENUBACKUP'    => MENUBACKUP,
                                 'MENUDESIGN'    => MENUDESIGN));

      $tpl->setVariable(array('choosenav1' => $choosenav1,
                              'choosenav2' => $choosenav2,
                              'choosenav3' => $choosenav3,
                              'choosenav4' => $choosenav4,
                              'choosenav5' => $choosenav5,
                              'choosenav6' => $choosenav6,
                              'choosenav7' => $choosenav7,
                              'choosenav8' => $choosenav8,
                              'choosenav9' => $choosenav9,
                              'choosenav10' => $choosenav10));

      // Find out the catalogue is parent or child
      if($_POST['id_parent'])
      {
         if($_POST['level']) { $level=$_POST['level']; }
         else { $level='parent'; }
         $_GET['id_parent']=$_POST['id_parent'];
      }
      else
      {
         if($_GET['id_parent']) { $level='child'; }
         else { $level='parent'; }
      }

      // Find out a max value of id_cat
      if(!$_GET['id_parent'])
      {
         $query = "SELECT MAX(id_cat) FROM ".DB_CATALOG."";
         $num = $dbh->query($query);

         if($num) $qid = mysqli_fetch_assoc($num);

         $pos = $qid['MAX(id_cat)']+1;
         $num->close();
      }
      else { $pos = $_GET['id_parent']; }

      if($level == 'child') { $go_back = "<a href=\"category.php?id_parent=".$_GET['id_parent']."\">$STR_GO_BACK</a>"; }
      else { $go_back = "<a href=\"category.php\">$STR_GO_BACK</a>"; }

      $hidden_fild = "<input type=hidden name=\"id_parent\" value=$pos>
      <input type=hidden name=\"level\" value=$level>";

      $tpl->setVariable(array('REQUIRED_FIELDS' => REQUIRED_FIELDS,
                              'CATEGORY'        => CATEGORY,
                              'DESCRIPTION'     => DESCRIPTION,
                              'KEYWORDS'        => KEYWORDS));

      $tpl->setVariable(array('go_back'     => $go_back,
                              'php_self'    => $_SERVER['PHP_SELF'],
                              'GO_BACK'     => $STR_GO_BACK,
                              'error'       => $error,
                              'name'        => $_POST['name'],
                              'description' => $_POST['description'],
                              'keywords'    => $_POST['keywords'],
                              'button'      => $STR_BUTTON_ADD,
                              'hidden_fild' => $hidden_fild));

      // Count a quantity of the links
      $query = "SELECT COUNT(*) FROM ".DB_LINK." WHERE hide = 'show'";
      $result = $dbh->query($query);
      $total = $result->fetch_assoc();

      // Clear the descriptor
      $result->close();

      if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
      else $LOGO = LOGO;

      // footer
      $tpl->setVariable(array('total_links' => $total['COUNT(*)'],
                              'help'        => $help,
                              'AUTHOR'      => AUTHOR,
                              'LOGO'        => $LOGO,
                              'WEBSITE'     => WEBSITE,
                              'HELPPAGE'    => HELPPAGE,
                              'FAQPAGE'     => FAQPAGE,
                              'LINKS_IN_CATALOG' => LINKS_IN_CATALOG));

      $tpl->show();
   }

   // Close a DB connection
   $dbh->close();
}
catch(ExceptionObject $exc)
{
   require_once("../lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("../lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("../lib/exception_member_debug.inc");
}

?>