<?php

///////////////////////////////////////
// My Links Manager v1.0.0 beta      //
// (C) 2006-2011, Alexander Yanitsky //
// Web site: janicky.com             //
// Email: janickiy@mail.ru           //
// ICQ: 305-972                      //
// MSN: janickiy@live.ru             //
///////////////////////////////////////


// Level of processing of mistakes
Error_Reporting(E_ALL & ~E_NOTICE);

define("DEBUG", 1);

// Switch off the identifier of session
@ini_set('session.use_trans_sid', 0);

// Start a new session
session_start();

// Require necessary classes
require_once "class/class.exception_mysql.php";
require_once "class/class.exception_object.php";
require_once "class/class.exception_member.php";
require_once 'class/Sigma.php';

// Require necessary libs
require_once "lib/connect.inc";
require_once "lib/function.inc";

try
{
   // Get a settings of catalogue
   $query = "SELECT * FROM ".DB_SETTING."";
   $result = $dbh->query($query);

   if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

   $settings = $result->fetch_array();

   // Clear the descriptor
   $result->close();

   if($settings['language'] == 'ru') { $charset = "windows-1251"; }
   else { $charset = "utf-8"; }

   // interface modules, the description of pages and meta tags
   require "templates/language/".$settings['language']."/add_url.inc";
   require "templates/language/".$settings['language']."/language.inc";

   if($settings['static'] == 1) { $go_back = "index.html"; }
   else { $go_back = "index.php"; }

   // Meta tags
   $description = $descriptionpage;
   $keywords = "";
   $title = $titlepage;

   $error = Array();

   $error[1] = "";
   $error[2] = "";
   $error[3] = "";
   $error[4] = "";
   $error[5] = "";
   $error[6] = "";
   $error[7] = "";
   $error[8] = "";
   $error[9] = "";
   $error[10] = "";

   $action = "";
   $action = $_POST["action"];

   if(!empty($action))
   {
      // Cut out a tags and a blanks
      $_POST["name"] = stripslashes(trim(htmlspecialchars($_POST["name"])));
      $_POST["email"] = strtolower(trim($_POST["email"]));
      $_POST["kwdlink"] = strtolower(trim(htmlspecialchars($_POST["kwdlink"])));
      $_POST["url"] = strtolower(trim($_POST["url"]));
      $_POST["url_link"] = trim($_POST["url_link"]);
      $_POST["description_link"] = stripslashes(trim(htmlspecialchars($_POST["description_link"])));
      $_POST["full_description_link"] = stripslashes(trim(htmlspecialchars($_POST["full_description_link"])));
      $_POST["htmlcode_link"] = stripslashes(trim($_POST["htmlcode_link"]));
      $_POST["htmlcode_banner"] = stripslashes(trim($_POST["htmlcode_banner"]));

      // Cut out http:// from url of site
      if(!empty($_POST["url"]))
      {
         if(substr($_POST["url"], 0, 7) == "http://") { $_POST["url"] = str_replace('http://','',$_POST["url"]); }
         if(strpos($_POST["url"],'/')>0) { list($_POST["url"]) = explode('/',$_POST["url"]); }
      }

      // Cut out http:// from url address of reciprocal link
      if(!empty($_POST["url_link"]) and $settings['search'] == "yes")
      {
         if(substr(strtolower($_POST["url_link"]), 0, 7) == "http://") $_POST["url_link"] = str_replace('http://','',$_POST["url_link"]);
      }

      // Cut out all unnecessary tags and javascript from HTML code of link
      $_POST["htmlcode_link"] = cuttags($_POST["htmlcode_link"]);

      // Cut out all unnecessary tags and javascript from HTML code of banner
      $_POST["htmlcode_banner"] = cuttags($_POST["htmlcode_banner"]);

      // Check category is chosen, if not then print error
      if($_POST["id_cat"] == 0)
      {
         $action = "";
         $error[1] = $error[1]." $MSG_ERROR_CHOOSE_CATEGORY";
      }

      // Check catalogue already has adding link, if it has then print error
      if(!empty($_POST["url"]))
      {
         $src_url = $_POST["url"];
         if((substr($_POST["url"], 0, 4)) == "www.") $src_url = str_replace('www.','',$src_url);
         $src_url = str_replace('.','\\.',$src_url);

         $query = "SELECT * FROM ".DB_LINK." WHERE url RLIKE '^(www\\.)?$src_url$' AND hide = 'show' OR
                                                   url RLIKE '^(www\\.)?$src_url$' AND hide = 'black'";
         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
         if($result->num_rows > 0)
         {
            $action = "";
            $error[3] = $error[3]." $MSG_ERROR_EXIST_SITE";
         }

         // Clear the descriptor
         $result->close();

         $query = "SELECT * FROM ".DB_LINK." WHERE url RLIKE '^(www\\.)?$src_url$' AND hide = 'new' OR
                                                   url RLIKE '^(www\\.)?$src_url$' AND hide = 'hide'";

         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }
         if($result->num_rows > 0)
         {
            $action = "";
            $error3 = $error3." $MSG_ERROR_AWAIT_CHECK";
         }

         // Clear the descriptor
         $result->close();
      }

      // Check on, whether the adding site on the same hosting as catalogue is located
      if(!empty($_POST["url"]) and $settings['common_host'] == "yes")
      {
         if(common_host ($_POST["url"]) == true)
         {
            $action = "";
            $error[3] = $error[3]." $MSG_ERROR_SAME_HOSTING";
         }
      }

      // Check on, whether the url address of reciprocal link has the url address of catalogue in arg=value
      if(!empty($_POST["url_link"]) and $settings['query_check'] == "yes")
      {
         if(query_check ($_POST["url_link"]) == true)
         {
            $action = "";
            $error[4] = $error[4]." $MSG_ERROR_ARG_VALUE";
         }
      }

      // Verify domen of reciprocal link and of catalogue
      if(!empty($_POST["url_link"]) and $settings['search'] == "yes")
      {
         if(native_check_link($_POST["url_link"],$_POST["url"]) == true)
         {
            $action = "";
            $error[4] = $error[4]." $MSG_ERROR_VERIFY_DOMEN ";
         }
      }

      // Check the email on valid
      if(!empty($_POST["email"]))
      {
         if(check_email($_POST["email"]) == true)
         {
            $action = "";
            $error[5]= $error[5]." $MSG_ERROR_WRONG_EMAIL";
         }
      }

      // Check the url address on valid
      if(!empty($_POST["url"]))
      {
         if(check_url($_POST["url"]) == true)
         {
            $action = "";
            $error[3]= $error[3]." $MSG_ERROR_WRONG_URL";
         }

         if(native_check_url($_POST["url"], $_SERVER["SERVER_NAME"]) == true)
         {
            $action = "";
            $error[3] = $error[3]." $MSG_ERROR_NOT_YOUR_SITE";
         }
      }

      // Check brief description of site on spaces
      if(!empty($_POST["description_link"]))
      {
         if(len_description($_POST["description_link"]) == true)
         {
            $action = "";
            $error[6] = $error[6]." $MSG_ERROR_BRIEF_DESC_SPACES";
         }
      }

      // Count the number of characters of full description, if it more than a limit then print error
      if(!empty($_POST["full_description_link"]))
      {
         if(len_description($_POST["full_description_link"]) == true)
         {
            $action = "";
            $error[10] = $error[10]." $MSG_ERROR_FULL_DESC_SPACES";
         }
      }

      // Check min and max number of characters in brief description
      if(!empty($_POST["description_link"]))
      {
         if(len_descriptionlink_min($_POST["description_link"]) == true)
         {
            $action = "";
            $error[6] = $error[6]." $MSG_ERROR_BRIEF_DESC_MIN_CHAR";
         }

         if(len_descriptionlink_max($_POST["description_link"]) == true)
         {
            $action = "";
            $error[6] = $error[6]." $MSG_ERROR_BRIEF_DESC_MAX_CHAR";
         }
      }

      // Check min and max number of characters in full description
      if(!empty($_POST["full_description_link"]))
      {
         if(len_full_description_min($_POST["full_description_link"]) == true)
         {
            $action = "";
            $error[10] = $error[10]." $MSG_ERROR_FULL_DESC_MIN_CHAR";
         }

         if(len_full_description_max($_POST["full_description_link"]) == true)
         {
            $action = "";
            $error[10] = $error[10]." $MSG_ERROR_FULL_DESC_MAX_CHAR";
         }
      }

      // Count the number of characters in HTML code of link, if it more than a limit then print error
      if(!empty($_POST["htmlcode_link"]))
      {
         if(len_htmlcode ($_POST["htmlcode_link"]) == true)
         {
            $action = "";
            $error[7] = $error[7]." $MSG_ERROR_HTML_LINK_LIMIT";
         }
      }

      // Count the number of characters in HTML code of banner, if it more than a limit then print error
      if(!empty($_POST["htmlcode_banner"]))
      {
         if(len_htmlcode ($_POST["htmlcode_banner"]) == true)
         {
            $action = "";
            $error[8] = $error[8]." $MSG_ERROR_HTML_BANNER_LIMIT";
         }
      }

      // if $settings['robot'] == yes then check on,
      // whether there's a prohibition on index of a reciprocal link by meta tag <meta name=robot>
      if(!empty($_POST["url_link"]) and $settings['search'] == "yes")
      {
         if(check_meta ($_POST["url_link"]) == true)
         {
            $action = "";
            $error[4] = $error[4]." $MSG_ERROR_CLOSE_INDEX_TAGS";
         }

         // check a directory if it is closed for index then print error
         if(check_robots ($_POST["url_link"]) == true)
         {
            $action = "";
            $error[4] = $error[4]." $MSG_ERROR_CLOSE_INDEX_DIR";
         }

         // if $settings['no_add_link'] == yes, check the number of links on the page of a reciprocal link
         // if the number of links is more than $settings['no_link'] print the notice
         if($settings['no_add_link'] == "yes" and !empty($_POST["url"]))
         {
            if(count_link ($_POST["url_link"]) == true)
            {
               $action = "";
               $error[4] = $error[4]." $MSG_ERROR_NUMBER_URL";
            }
         }
      }

      // Check HTML code of link on valid
      if(!empty($_POST["htmlcode_link"]))
      {
         if(check_htmlcode_link ($_POST["htmlcode_link"]) == true)
         {
            $action = "";
            $error[7] = $error[7]." $MSG_ERROR_WRONG_HTML_LINK";
         }

         // if $settings['many_link'] == yes,
         // check whether on HTML code of link is multiple url
         if($settings['many_link'] == "yes")
         {
            if(check_many_link ($_POST["htmlcode_link"]) == true)
            {
               $action = "";
               $error[7] = $error[7]." $MSG_ERROR_MULTIURL_LINK";
            }
         }
         else
         {
            if($settings['others'] == "yes" and !empty($_POST["url"]))
            {
               if(check_many_link_native ($_POST["htmlcode_link"],$_POST["url"]) == true)
               {
                  $action = "";
                  $error[7] = $error[7]." $MSG_ERROR_MULTIURL";
               }
            }
         }
      }

      // Verify captcha
      if(!empty($_POST["securityCode"]) && $settings['show_sec_code'] == "yes")
      {
         $query = "SELECT securityCode FROM ".DB_CAPTCHA." WHERE id_session='".session_id()."'";
         $result = $dbh->query($query);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$insert,"Error executing SQL query!"); }

         $row = $result->fetch_array();

         // Clear the descriptor
         $result->close();

         if(trim($_POST['securityCode']) != $row['securityCode'])
         {
            $action = "";
            $error[9] = $error[9]." $MSG_ERROR_WRONG_CAPTCHA ";
         }
      }

      // If $settings['search'] == yes, then check
      // the find a reciprocal link on our site
      if(!empty($_POST["url_link"]))
      {
         if($settings['search'] == "yes")
         {
            if(check_url_link ($_POST["url_link"],$settings) == true)
            {
               $action = "";
               $error[4] = $error[4]." $MSG_ERROR_NOT_RECIPROCAL_LINK";
            }
         }
      }

      // Check HTML code of banner on valid
      if(!empty($_POST["htmlcode_banner"]))
      {
         // check htmlcode of banner
         if(check_htmlcode_banner($_POST["htmlcode_banner"]) == true)
         {
            $action = "";
            $error[8] = $error[8]." $MSG_ERROR_WRONG_HTML_BANNER";
         }
         else
         {
            // check image size of banner
            if(check_size_banner($_POST["htmlcode_banner"]) == true)
            {
               $action = "";
               $error[8] = $error[8]." $MSG_ERROR_SIZE_BANNER";
            }

            // check image type of banner
            if(check_type_image_banner($_POST["htmlcode_banner"]) == true)
            {
               $action = "";
               $error[8] = $error[8]." $MSG_ERROR_TYPE_BANNER ";
            }
         }
      }

      // Check all required fields is filled
      // Check site name, if its value is empty print error
      if(empty($_POST["name"]))
      {
         $action = "";
         $error[2] = $error[2]." $MSG_ERROR_NOT_FILLED_NAME";
      }

      // Check site address, if its value is empty print error
      if(empty($_POST["url"]))
      {
         $action = "";
         $error[3]= $error[3]." $MSG_ERROR_NOT_FILLED_URL";
      }

      // Check reciprocal link, if its value is empty print error
      if($settings['search'] == "yes")
      {
         if(empty($_POST["url_link"]))
         {
            $action = "";
            $error[4] = $error[4]." $MSG_ERROR_NOT_FILLED_URL_LINK";
         }
      }

      // Check email, if its value is empty print error
      if(empty($_POST["email"]))
      {
         $action = "";
         $error[5] = $error[5]." $MSG_ERROR_NOT_FILLED_EMAIL";
      }

      // Check description of link, if its value is empty print error
      if(empty($_POST["description_link"]))
      {
         $action = "";
         $error[6] = $error[6]." $MSG_ERROR_NOT_FILLED_BRIEF_DESC";
      }

      // Check CAPTCHA, if its value is empty print error
      if(empty($_POST["securityCode"]) and $settings['show_sec_code'] == "yes")
      {
         $action = "";
         $error[9] = $error[9]." $MSG_ERROR_NOT_FILLED_CAPTCHA ";
      }

      // Check full description of link, if its value is empty print error
      if(empty($_POST["full_description_link"]))
      {
         $action = "";
         $error[10] = $error[10]." $MSG_ERROR_NOT_FILLED_FULL_DESC";
      }

      // Shield a special characters
      if(!get_magic_quotes_gpc())
      {
         $_POST["name"] = mysql_escape_string($_POST["name"]);
         $_POST["email"] = mysql_escape_string($_POST["email"]);
         $_POST["kwdlink"] = mysql_escape_string($_POST["kwdlink"]);
         $_POST["url"] = mysql_escape_string($_POST["url"]);
         $_POST["url_link"] = mysql_escape_string($_POST["url_link"]);
         $_POST["description_link"] = mysql_escape_string($_POST["description_link"]);
         $_POST["full_description_link"] = mysql_escape_string($_POST["full_description_link"]);
         $_POST["htmlcode_link"] = mysql_escape_string($_POST["htmlcode_link"]);
         $_POST["htmlcode_banner"] = mysql_escape_string($_POST["htmlcode_banner"]);
         $_POST["id_cat"] = mysql_escape_string($_POST["id_cat"]);
      }

      $error[1] = trim($error[1]);
      $error[2] = trim($error[2]);
      $error[3] = trim($error[3]);
      $error[4] = trim($error[4]);
      $error[5] = trim($error[5]);
      $error[6] = trim($error[6]);
      $error[7] = trim($error[7]);
      $error[8] = trim($error[8]);
      $error[9] = trim($error[9]);
      $error[10] = trim($error[10]);

      // Add the link if there are not any errors
      if(empty($error[1]) and empty($error[2]) and empty($error[3]) and empty($error[4]) and empty($error[5]) and empty($error[6]) and empty($error[7]) and empty($error[8]) and empty($error[9]) and empty($error[10]))
      {
         if(empty($settings['add_link']) or $settings['add_link'] == "no") { $add = "new"; }
         else { $add = "show"; }

         if($settings['search'] == "yes") { $check_link = "yes"; }
         else { $check_link = "no"; }

         $cod = getRandomCod();

         // Form the SQL query to add link
         $insert = "INSERT INTO ".DB_LINK." VALUES (0,
                                                   '".$_POST['name']."',
                                                   '".$_POST['url']."',
                                                   '".$_POST['url_link']."',
                                                   NOW(),
                                                   '0000-00-00 00:00:00',
                                                   '".$_POST["email"]."',
                                                   '".$_POST["kwdlink"]."',
                                                   '".$_POST["description_link"]."',
                                                   '".$_POST["full_description_link"]."',
                                                   '".$_POST["htmlcode_link"]."',
                                                   '".$_POST["htmlcode_banner"]."',
                                                   '".$_POST['id_cat']."',
                                                   '$add',
                                                   '$cod',
                                                   '$check_link',
                                                   0,
                                                   '',
                                                   0);";

         $result = $dbh->prepare($insert);

         if(!$result) { throw new ExceptionMySQL($dbh->error,$insert,"Error executing SQL query!"); }

         $result->execute();

         // Notify user about his link was added to check's turn
         $id = $result->insert_id;

         if($settings['static'] == "1") { $adr = 'http://'.$_SERVER['SERVER_NAME'].root().'link_'.$id.'.html'; }
         else { $adr = 'http://'.$_SERVER['SERVER_NAME'].root().'index.php?id_link='.$id.''; }

         $date = "".date("d.m.Y . G:i:s")."";

         $msgUser = $settings['send_mail_1'];
         $msgUser = str_replace("{[HTTP_HOST]}", $HTTP_HOST, $msgUser);
         $msgUser = str_replace("{[ADRESS]}", $adr, $msgUser);
         $msgUser = str_replace("{[NAME]}", $_POST["name"], $msgUser);
         $msgUser = str_replace("{[EMAIL]}", $_POST["email"], $msgUser);
         $msgUser = str_replace("{[URL]}", $_POST["url"], $msgUser);
         $msgUser = str_replace("{[DESCRIPTION]}", $_POST["description_link"], "$msgUser");
         $msgUser = str_replace("{[DATE]}", $date, "$msgUser");

         $fromname = $HTTP_HOST;
         $fromname_encoded = base64_encode($fromname);
         $fromname_packed = "=?$charset?B?$fromname_encoded?=";
         $fromaddr  = $settings['admin_email'];

         $headers = "MIME-Version: 1.0\n";
         $headers .= "From: $fromname_packed <$fromaddr>\n";
         $headers .= "Content-type: text/plain; charset=$charset\n";
         $headers .= "Content-Transfer-Encoding: 8bit\r\n";

         if($settings['add_link'] == no) { @mail($_POST["email"], $STR_SUBJECT_WAIT, $msgUser, $headers); }

         // Notify admin of catalogue about a new link
         if($settings['send_mail'] == "yes")
         {
            $msgAdmin = $settings['send_mail_5'];
            $msgAdmin = str_replace("{[HTTP_HOST]}", $HTTP_HOST, $msgAdmin);
            $msgAdmin = str_replace("{[NAME]}", $_POST["name"], $msgAdmin);
            $msgAdmin = str_replace("{[EMAIL]}", $_POST["email"], $msgAdmin);
            $msgAdmin = str_replace("{[URL]}", $_POST["url"], $msgAdmin);
            $msgAdmin = str_replace("{[DESCRIPTION]}", $_POST["description_link"], $msgAdmin);
            $msgAdmin = str_replace("{[DATE]}", $date, $msgAdmin);

            @mail($settings['admin_email'], '', $STR_SUBJECT_NEWLINK, $headers);
         }

         // print the message if the SQL query was executed successfully
         // header
         require "nulltop.php";

         echo "<center><p class=msg>{$settings['from_add_message']}</p><br /><br />";
         echo "<a href=add_url.php>$STR_ADD_MORE_LINK</a><br /><br />";
         echo "<a href=$go_back>$STR_GO_BACK</a></center><br />";

         // footer
         require "nullbottom.php";

         // Close a DB connection
         $dbh->close();

         exit();
      }
   }

   if(empty($action))
   {
      $rules = nl2br(htmlspecialchars($settings['rules']));

      if($_POST['id_cat'] == 0) { $slct0 = "selected"; }
      else { $slct0 = ""; }

      // Print th elist of catalogues and subcatalogues
      $query = "SELECT * FROM ".DB_CATALOG." ORDER BY name";
      $result = $dbh->query($query);

      if(!$result) { throw new ExceptionMySQL($dbh->error,$query,"Error executing SQL query!"); }

      $arraycat = Array();
      $array_id_parent = Array();

      while($list = $result->fetch_array())
      {
         $arraycat[] = array($list['name'], $list['id_cat'],$list['id_parent']);
         $array_id_parent[] = $list['id_parent'];
      }

      // Clear the descripto
      $result->close();

      $option = '';

      for($i=0; $i < count($arraycat); $i++)
      {
         if($arraycat[$i][1] == $_POST['id_cat']) { $slct = "selected"; }
         else { $slct = ""; }

         if($array_id_parent[$i] == $arraycat[$i][1])
         {
            $count_sub=0;

            for($m=0; $m < count($arraycat); $m++)
            {
               if($array_id_parent[$i] == $arraycat[$m][2])
               {
                  if($array_id_parent[$i] != $arraycat[$m][1]) $count_sub++;
               }
            }

            if($count_sub != 0)
            {
               $option .= "<option value=".$arraycat[$i][1]." style=\"color: graytext;\" disabled=\"disabled\">".$arraycat[$i][0]."</option>\r\n";

               for($n=0; $n < count($arraycat); $n++)
               {
                  if($array_id_parent[$i] == $arraycat[$n][2])
                  {
                     if($array_id_parent[$i] != $arraycat[$n][1])
                     {
                        if($_POST['id_cat'] == $arraycat[$n][1]) { $slct = "selected"; }
                        else { $slct = ""; }

                        $option .= "<option value=".$arraycat[$n][1]." style=\"color: menutext;\" $slct>&nbsp;&nbsp;&nbsp;".$arraycat[$n][0]."</option>\r\n";
                     }
                  }
               }
            }
            else
            {
               $option .= "<option value=".$arraycat[$i][1]." style=\"color: menutext;\" $slct>".$arraycat[$i][0]."</option>\r\n";
            }
         }
      }

      // include template
      $tpl = new HTML_Template_Sigma('.');
      $tpl->loadTemplateFile("templates/add_url.html");

      $onload = $onload = 'onLoad="total_load();"';

      // header
      $tpl->setVariable(array('version'     => $version,
                              'title'       => $title,
                              'keywords'    => $keywords,
                              'description' => $description,
                              'charset'     => $charset,
                              'onload'      => $onload));

      $tpl->setVariable(array('GO_TO_CATALOG' =>  GO_TO_CATALOG,
                              'LEFT' => LEFT,
                              'FROM' => FROM,
                              'TO'   => TO,
                              'INITIAALIZATION_ERROR_INTERFACE' => INITIAALIZATION_ERROR_INTERFACE,
                              'PROBLEMS_OF_CONNECTION' => PROBLEMS_OF_CONNECTION,
                              'ADDING_LINK'            => ADDING_LINK,
                              'php_self'               => $_SERVER['PHP_SELF'],
                              'go_back'                => $go_back,
                              'REQUIRED_FIELD'         => REQUIRED_FIELD));

      // Print the rules of catalogue
      if(!empty($settings['rules']))
      {
         $tpl->setVariable(array('rules' => $rules,
                                 'RULES' => RULES));
         $tpl->parse('rules');
      }

      // Print HTML code of site
      if(!empty($settings['code_site1']) OR !empty($settings['code_site2']) OR !empty($settings['code_site3']))
      {
         $tpl->setVariable(array('HTML_CODE_OF_LINK_FOR_THIS' => HTML_CODE_OF_LINK_FOR_THIS));
         $tpl->parse('links_row');
      }

      if(!empty($settings['code_site1']))
      {
         $tpl->setVariable(array('code_site1' => $settings['code_site1']));
         $tpl->parse('code_site1');
      }

      if(!empty($settings['code_site2']))
      {
         $tpl->setVariable(array('code_site2' => $settings['code_site2']));
         $tpl->parse('code_site2');
      }

      if(!empty($settings['code_site3']))
      {
         $tpl->setVariable(array('code_site3' => $settings['code_site3']));
         $tpl->parse('code_site3');
      }

      // Print HTML code of banner
      if(!empty($settings['code_banner1']) OR !empty($settings['code_banner2']) OR !empty($settings['code_banner3']))
      {
         $tpl->setVariable(array('HTML_CODE_OF_BANNER_FOR_THIS' => HTML_CODE_OF_BANNER_FOR_THIS));
         $tpl->parse('banners');
      }

      if(!empty($settings['code_banner1']))
      {
         $tpl->parse('code_banner1');
         $tpl->setVariable(array('code_banner1' => $settings['code_banner1']));
      }
      if(!empty($settings['code_banner2']))
      {
         $tpl->parse('code_banner2');
         $tpl->setVariable(array('code_banner2' => $settings['code_banner2']));
      }
      if(!empty($settings['code_banner3']))
      {
         $tpl->parse('code_banner3');
         $tpl->setVariable(array('code_banner3' => $settings['code_banner3']));
      }

      // select category
      $tpl->setVariable(array('slct'   => $slct0,
                              'option' => $option,
                              'error1' => $error[1],
                              'CHOOSE_YOUR_CATEGORY' => CHOOSE_YOUR_CATEGORY,
                              'CHOOSE_CATEGORY'      => CHOOSE_CATEGORY));

      // name
      $tpl->setVariable(array('name'         => $_POST['name'],
                              'error2'       => $error[2],
                              'NAME_UR_SITE' => NAME_UR_SITE));

      // url
      $tpl->setVariable(array('url'                => $_POST['url'],
                              'error3'             => $error[3],
                              'ADDRESS_OF_UR_SITE' => ADDRESS_OF_UR_SITE));

      // email
      $tpl->setVariable(array('email'    => $_POST['email'],
                              'error5'   => $error[5],
                              'UR_EMAIL' => UR_EMAIL));

      // keywords
      $tpl->setVariable(array('kwdlink'  => $_POST['kwdlink'],
                              'KEYWORDS' => KEYWORDS,
                              'COMMA_SEPAR_LIST' => COMMA_SEPAR_LIST));

      $tpl->setVariable(array('ONLY_TEXT_NOT_CODE' => ONLY_TEXT_NOT_CODE,
                              'CHARACTERS'         => CHARACTERS));

      // description of link
      $tpl->setVariable(array('description_link'             => $_POST['description_link'],
                              'count_description_link_min'   => $settings['count_description_link_min'],
                              'count_description_link_max'   => $settings['count_description_link_max'],
                              'error6'                       => $error[6],
                              'BRIEF_DESCRIPTION_OF_UR_SITE' => BRIEF_DESCRIPTION_OF_UR_SITE));

      // full description of link
      $tpl->setVariable(array('full_description_link'          => $_POST['full_description_link'],
                              'count_fulldescription_link_min' => $settings['count_fulldescription_link_min'],
                              'count_fulldescription_link_max' => $settings['count_fulldescription_link_max'],
                              'error10'                        => $error[10],
                              'FULL_DESCRIPTION_OF_UR_SITE'    => FULL_DESCRIPTION_OF_UR_SITE));

      $tpl->setVariable(array('NO_MORE' => NO_MORE,
                              'IF_ANY'  => IF_ANY));

      // htmlcode of link
      $tpl->setVariable(array('limit_char_html_link' => $settings['count_html'],
                              'htmlcode_link'        => $_POST['htmlcode_link'],
                              'error7'               => $error[7],
                              'HTML_CODE_OF_LINK'    => HTML_CODE_OF_LINK));

      // htmlcode of banner
      $tpl->setVariable(array('limit_char_html_banner' => $settings['count_html'],
                              'htmlcode_banner'        => $_POST['htmlcode_banner'],
                              'error8'                 => $error[8],
                              'HTML_CODE_BANNER'       => HTML_CODE_BANNER));

      // reciprocal link
      if($settings['search'] == "yes")
      {
         $tpl->setVariable(array('error4'                   => $error[4],
                                 'url_link'                 => $_POST['url_link'],
                                 'ADDRESS_OF_REC_LINK_PAGE' => ADDRESS_OF_REC_LINK_PAGE));

         $tpl->parse('search');
      }

      // CAPTCHA
      if($settings['show_sec_code'] == "yes")
      {
         $tpl->setVariable(array('error9'        => $error[9],
                                 'session_id'    => session_id(),
                                 'TYPE_SEC_CODE' => TYPE_SEC_CODE));

         $tpl->parse('show_sec_code');
      }

      $tpl->setVariable(array('STR_BUTTON_ADD'      => $STR_BUTTON_ADD,
                              'STR_BUTTON_RESET'    => $STR_BUTTON_RESET,
                              'SCRIPT_LINK_CATALOG' => SCRIPT_LINK_CATALOG));

      if($charset == 'utf-8') $LOGO = iconv('windows-1251','utf-8',LOGO);
      else $LOGO = LOGO;

      // footer
      $tpl->setVariable(array('LOGO'   => $LOGO,
                              'AUTHOR' => AUTHOR));

      // print html code
      $tpl->show();

      // Close a DB connection
      $dbh->close();
   }
}
catch(ExceptionObject $exc)
{
   require_once("lib/exception_object_debug.inc");
}
catch(ExceptionMySQL $exc)
{
   require_once("lib/exception_mysql_debug.inc");
}
catch(ExceptionMember $exc)
{
   require_once("lib/exception_member_debug.inc");
}

?>